/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.PutSubscriptionFilterRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class PutSubscriptionFilterRequestMarshaller
implements Marshaller<Request<PutSubscriptionFilterRequest>, PutSubscriptionFilterRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutSubscriptionFilterRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PutSubscriptionFilterRequest> marshall(PutSubscriptionFilterRequest putSubscriptionFilterRequest) {
        if (putSubscriptionFilterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutSubscriptionFilterRequest> request = new DefaultRequest<PutSubscriptionFilterRequest>(putSubscriptionFilterRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.PutSubscriptionFilter");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putSubscriptionFilterRequest.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(putSubscriptionFilterRequest.getLogGroupName());
            }
            if (putSubscriptionFilterRequest.getFilterName() != null) {
                jsonGenerator.writeFieldName("filterName").writeValue(putSubscriptionFilterRequest.getFilterName());
            }
            if (putSubscriptionFilterRequest.getFilterPattern() != null) {
                jsonGenerator.writeFieldName("filterPattern").writeValue(putSubscriptionFilterRequest.getFilterPattern());
            }
            if (putSubscriptionFilterRequest.getDestinationArn() != null) {
                jsonGenerator.writeFieldName("destinationArn").writeValue(putSubscriptionFilterRequest.getDestinationArn());
            }
            if (putSubscriptionFilterRequest.getRoleArn() != null) {
                jsonGenerator.writeFieldName("roleArn").writeValue(putSubscriptionFilterRequest.getRoleArn());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

