/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cognitosync.model.DescribeDatasetRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DescribeDatasetRequestMarshaller
implements Marshaller<Request<DescribeDatasetRequest>, DescribeDatasetRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeDatasetRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeDatasetRequest> marshall(DescribeDatasetRequest describeDatasetRequest) {
        if (describeDatasetRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeDatasetRequest> request = new DefaultRequest<DescribeDatasetRequest>(describeDatasetRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", describeDatasetRequest.getIdentityPoolId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(describeDatasetRequest.getIdentityPoolId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{IdentityId}", describeDatasetRequest.getIdentityId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(describeDatasetRequest.getIdentityId()), false) : "");
        uriResourcePath = uriResourcePath.replace("{DatasetName}", describeDatasetRequest.getDatasetName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(describeDatasetRequest.getDatasetName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

