/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevents.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudwatchevents.model.PutRuleRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class PutRuleRequestMarshaller
implements Marshaller<Request<PutRuleRequest>, PutRuleRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PutRuleRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PutRuleRequest> marshall(PutRuleRequest putRuleRequest) {
        if (putRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutRuleRequest> request = new DefaultRequest<PutRuleRequest>(putRuleRequest, "AmazonCloudWatchEvents");
        request.addHeader("X-Amz-Target", "AWSEvents.PutRule");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putRuleRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(putRuleRequest.getName());
            }
            if (putRuleRequest.getScheduleExpression() != null) {
                jsonGenerator.writeFieldName("ScheduleExpression").writeValue(putRuleRequest.getScheduleExpression());
            }
            if (putRuleRequest.getEventPattern() != null) {
                jsonGenerator.writeFieldName("EventPattern").writeValue(putRuleRequest.getEventPattern());
            }
            if (putRuleRequest.getState() != null) {
                jsonGenerator.writeFieldName("State").writeValue(putRuleRequest.getState());
            }
            if (putRuleRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(putRuleRequest.getDescription());
            }
            if (putRuleRequest.getRoleArn() != null) {
                jsonGenerator.writeFieldName("RoleArn").writeValue(putRuleRequest.getRoleArn());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

