/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lightsail.model.transform;

import com.amazonaws.services.lightsail.model.Domain;
import com.amazonaws.services.lightsail.model.DomainEntry;
import com.amazonaws.services.lightsail.model.transform.DomainEntryJsonUnmarshaller;
import com.amazonaws.services.lightsail.model.transform.ResourceLocationJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.util.Date;

public class DomainJsonUnmarshaller
implements Unmarshaller<Domain, JsonUnmarshallerContext> {
    private static DomainJsonUnmarshaller instance;

    @Override
    public Domain unmarshall(JsonUnmarshallerContext context) throws Exception {
        Domain domain = new Domain();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    domain.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    domain.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("supportCode", targetDepth)) {
                    context.nextToken();
                    domain.setSupportCode(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    domain.setCreatedAt(context.getUnmarshaller(Date.class).unmarshall(context));
                }
                if (context.testExpression("location", targetDepth)) {
                    context.nextToken();
                    domain.setLocation(ResourceLocationJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    domain.setResourceType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("domainEntries", targetDepth)) {
                    context.nextToken();
                    domain.setDomainEntries(new ListUnmarshaller<DomainEntry>(DomainEntryJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return domain;
    }

    public static DomainJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DomainJsonUnmarshaller();
        }
        return instance;
    }
}

