/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.ecs.AmazonECS;
import com.amazonaws.services.ecs.model.DescribeServicesRequest;
import com.amazonaws.services.ecs.model.DescribeServicesResult;
import com.amazonaws.services.ecs.model.DescribeTasksRequest;
import com.amazonaws.services.ecs.model.DescribeTasksResult;
import com.amazonaws.services.ecs.waiters.DescribeServicesFunction;
import com.amazonaws.services.ecs.waiters.DescribeTasksFunction;
import com.amazonaws.services.ecs.waiters.ServicesInactive;
import com.amazonaws.services.ecs.waiters.ServicesStable;
import com.amazonaws.services.ecs.waiters.TasksRunning;
import com.amazonaws.services.ecs.waiters.TasksStopped;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonECSWaiters {
    private final AmazonECS client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonECSWaiters(AmazonECS client) {
        this.client = client;
    }

    public Waiter<DescribeTasksRequest> tasksRunning() {
        return new WaiterBuilder<DescribeTasksRequest, DescribeTasksResult>().withSdkFunction(new DescribeTasksFunction(this.client)).withAcceptors(new TasksRunning.IsSTOPPEDMatcher(), new TasksRunning.IsMISSINGMatcher(), new TasksRunning.IsRUNNINGMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(100), new FixedDelayStrategy(6))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeServicesRequest> servicesStable() {
        return new WaiterBuilder<DescribeServicesRequest, DescribeServicesResult>().withSdkFunction(new DescribeServicesFunction(this.client)).withAcceptors(new ServicesStable.IsMISSINGMatcher(), new ServicesStable.IsDRAININGMatcher(), new ServicesStable.IsINACTIVEMatcher(), new ServicesStable.IsTrueMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeServicesRequest> servicesInactive() {
        return new WaiterBuilder<DescribeServicesRequest, DescribeServicesResult>().withSdkFunction(new DescribeServicesFunction(this.client)).withAcceptors(new ServicesInactive.IsMISSINGMatcher(), new ServicesInactive.IsINACTIVEMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTasksRequest> tasksStopped() {
        return new WaiterBuilder<DescribeTasksRequest, DescribeTasksResult>().withSdkFunction(new DescribeTasksFunction(this.client)).withAcceptors(new TasksStopped.IsSTOPPEDMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(100), new FixedDelayStrategy(6))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

