/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeSecurityGroupsRequestMarshaller
implements Marshaller<Request<DescribeSecurityGroupsRequest>, DescribeSecurityGroupsRequest> {
    @Override
    public Request<DescribeSecurityGroupsRequest> marshall(DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {
        SdkInternalList describeSecurityGroupsRequestGroupNamesList;
        SdkInternalList describeSecurityGroupsRequestGroupIdsList;
        if (describeSecurityGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeSecurityGroupsRequest> request = new DefaultRequest<DescribeSecurityGroupsRequest>(describeSecurityGroupsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSecurityGroups");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeSecurityGroupsRequestFiltersList = (SdkInternalList)describeSecurityGroupsRequest.getFilters();
        if (!describeSecurityGroupsRequestFiltersList.isEmpty() || !describeSecurityGroupsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Object describeSecurityGroupsRequestFiltersListValue : describeSecurityGroupsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (((Filter)describeSecurityGroupsRequestFiltersListValue).getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(((Filter)describeSecurityGroupsRequestFiltersListValue).getName()));
                }
                if (!(filterValuesList = (SdkInternalList)((Filter)describeSecurityGroupsRequestFiltersListValue).getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeSecurityGroupsRequestGroupIdsList = (SdkInternalList)describeSecurityGroupsRequest.getGroupIds()).isEmpty() || !describeSecurityGroupsRequestGroupIdsList.isAutoConstruct()) {
            int groupIdsListIndex = 1;
            for (String describeSecurityGroupsRequestGroupIdsListValue : describeSecurityGroupsRequestGroupIdsList) {
                if (describeSecurityGroupsRequestGroupIdsListValue != null) {
                    request.addParameter("GroupId." + groupIdsListIndex, StringUtils.fromString(describeSecurityGroupsRequestGroupIdsListValue));
                }
                ++groupIdsListIndex;
            }
        }
        if (!(describeSecurityGroupsRequestGroupNamesList = (SdkInternalList)describeSecurityGroupsRequest.getGroupNames()).isEmpty() || !describeSecurityGroupsRequestGroupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String describeSecurityGroupsRequestGroupNamesListValue : describeSecurityGroupsRequestGroupNamesList) {
                if (describeSecurityGroupsRequestGroupNamesListValue != null) {
                    request.addParameter("GroupName." + groupNamesListIndex, StringUtils.fromString(describeSecurityGroupsRequestGroupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        return request;
    }
}

