/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.AssociationFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListAssociationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<AssociationFilter> associationFilterList;
    private Integer maxResults;
    private String nextToken;

    public List<AssociationFilter> getAssociationFilterList() {
        if (this.associationFilterList == null) {
            this.associationFilterList = new SdkInternalList();
        }
        return this.associationFilterList;
    }

    public void setAssociationFilterList(Collection<AssociationFilter> associationFilterList) {
        if (associationFilterList == null) {
            this.associationFilterList = null;
            return;
        }
        this.associationFilterList = new SdkInternalList<AssociationFilter>(associationFilterList);
    }

    public ListAssociationsRequest withAssociationFilterList(AssociationFilter ... associationFilterList) {
        if (this.associationFilterList == null) {
            this.setAssociationFilterList(new SdkInternalList<AssociationFilter>(associationFilterList.length));
        }
        for (AssociationFilter ele : associationFilterList) {
            this.associationFilterList.add(ele);
        }
        return this;
    }

    public ListAssociationsRequest withAssociationFilterList(Collection<AssociationFilter> associationFilterList) {
        this.setAssociationFilterList(associationFilterList);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListAssociationsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAssociationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssociationFilterList() != null) {
            sb.append("AssociationFilterList: ").append(this.getAssociationFilterList()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociationsRequest)) {
            return false;
        }
        ListAssociationsRequest other = (ListAssociationsRequest)obj;
        if (other.getAssociationFilterList() == null ^ this.getAssociationFilterList() == null) {
            return false;
        }
        if (other.getAssociationFilterList() != null && !other.getAssociationFilterList().equals(this.getAssociationFilterList())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssociationFilterList() == null ? 0 : this.getAssociationFilterList().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListAssociationsRequest clone() {
        return (ListAssociationsRequest)super.clone();
    }
}

