/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeHostsRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeHostsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeHostsRequest> {
    private SdkInternalList<Filter> filter;
    private SdkInternalList<String> hostIds;
    private Integer maxResults;
    private String nextToken;

    public List<Filter> getFilter() {
        if (this.filter == null) {
            this.filter = new SdkInternalList();
        }
        return this.filter;
    }

    public void setFilter(Collection<Filter> filter) {
        if (filter == null) {
            this.filter = null;
            return;
        }
        this.filter = new SdkInternalList<Filter>(filter);
    }

    public DescribeHostsRequest withFilter(Filter ... filter) {
        if (this.filter == null) {
            this.setFilter(new SdkInternalList<Filter>(filter.length));
        }
        for (Filter ele : filter) {
            this.filter.add(ele);
        }
        return this;
    }

    public DescribeHostsRequest withFilter(Collection<Filter> filter) {
        this.setFilter(filter);
        return this;
    }

    public List<String> getHostIds() {
        if (this.hostIds == null) {
            this.hostIds = new SdkInternalList();
        }
        return this.hostIds;
    }

    public void setHostIds(Collection<String> hostIds) {
        if (hostIds == null) {
            this.hostIds = null;
            return;
        }
        this.hostIds = new SdkInternalList<String>(hostIds);
    }

    public DescribeHostsRequest withHostIds(String ... hostIds) {
        if (this.hostIds == null) {
            this.setHostIds(new SdkInternalList<String>(hostIds.length));
        }
        for (String ele : hostIds) {
            this.hostIds.add(ele);
        }
        return this;
    }

    public DescribeHostsRequest withHostIds(Collection<String> hostIds) {
        this.setHostIds(hostIds);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public DescribeHostsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeHostsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    @Override
    public Request<DescribeHostsRequest> getDryRunRequest() {
        Request<DescribeHostsRequest> request = new DescribeHostsRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilter() != null) {
            sb.append("Filter: ").append(this.getFilter()).append(",");
        }
        if (this.getHostIds() != null) {
            sb.append("HostIds: ").append(this.getHostIds()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostsRequest)) {
            return false;
        }
        DescribeHostsRequest other = (DescribeHostsRequest)obj;
        if (other.getFilter() == null ^ this.getFilter() == null) {
            return false;
        }
        if (other.getFilter() != null && !other.getFilter().equals(this.getFilter())) {
            return false;
        }
        if (other.getHostIds() == null ^ this.getHostIds() == null) {
            return false;
        }
        if (other.getHostIds() != null && !other.getHostIds().equals(this.getHostIds())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
        hashCode = 31 * hashCode + (this.getHostIds() == null ? 0 : this.getHostIds().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public DescribeHostsRequest clone() {
        return (DescribeHostsRequest)super.clone();
    }
}

