/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codestar;

import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codestar.AWSCodeStarAsync;
import com.amazonaws.services.codestar.AWSCodeStarAsyncClientBuilder;
import com.amazonaws.services.codestar.AWSCodeStarClient;
import com.amazonaws.services.codestar.model.AssociateTeamMemberRequest;
import com.amazonaws.services.codestar.model.AssociateTeamMemberResult;
import com.amazonaws.services.codestar.model.CreateProjectRequest;
import com.amazonaws.services.codestar.model.CreateProjectResult;
import com.amazonaws.services.codestar.model.CreateUserProfileRequest;
import com.amazonaws.services.codestar.model.CreateUserProfileResult;
import com.amazonaws.services.codestar.model.DeleteProjectRequest;
import com.amazonaws.services.codestar.model.DeleteProjectResult;
import com.amazonaws.services.codestar.model.DeleteUserProfileRequest;
import com.amazonaws.services.codestar.model.DeleteUserProfileResult;
import com.amazonaws.services.codestar.model.DescribeProjectRequest;
import com.amazonaws.services.codestar.model.DescribeProjectResult;
import com.amazonaws.services.codestar.model.DescribeUserProfileRequest;
import com.amazonaws.services.codestar.model.DescribeUserProfileResult;
import com.amazonaws.services.codestar.model.DisassociateTeamMemberRequest;
import com.amazonaws.services.codestar.model.DisassociateTeamMemberResult;
import com.amazonaws.services.codestar.model.ListProjectsRequest;
import com.amazonaws.services.codestar.model.ListProjectsResult;
import com.amazonaws.services.codestar.model.ListResourcesRequest;
import com.amazonaws.services.codestar.model.ListResourcesResult;
import com.amazonaws.services.codestar.model.ListTeamMembersRequest;
import com.amazonaws.services.codestar.model.ListTeamMembersResult;
import com.amazonaws.services.codestar.model.ListUserProfilesRequest;
import com.amazonaws.services.codestar.model.ListUserProfilesResult;
import com.amazonaws.services.codestar.model.UpdateProjectRequest;
import com.amazonaws.services.codestar.model.UpdateProjectResult;
import com.amazonaws.services.codestar.model.UpdateTeamMemberRequest;
import com.amazonaws.services.codestar.model.UpdateTeamMemberResult;
import com.amazonaws.services.codestar.model.UpdateUserProfileRequest;
import com.amazonaws.services.codestar.model.UpdateUserProfileResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCodeStarAsyncClient
extends AWSCodeStarClient
implements AWSCodeStarAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCodeStarAsyncClientBuilder asyncBuilder() {
        return AWSCodeStarAsyncClientBuilder.standard();
    }

    AWSCodeStarAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateTeamMemberResult> associateTeamMemberAsync(AssociateTeamMemberRequest request) {
        return this.associateTeamMemberAsync(request, null);
    }

    @Override
    public Future<AssociateTeamMemberResult> associateTeamMemberAsync(AssociateTeamMemberRequest request, final AsyncHandler<AssociateTeamMemberRequest, AssociateTeamMemberResult> asyncHandler) {
        final AssociateTeamMemberRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateTeamMemberResult>(){

            @Override
            public AssociateTeamMemberResult call() throws Exception {
                AssociateTeamMemberResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeAssociateTeamMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request) {
        return this.createProjectAsync(request, null);
    }

    @Override
    public Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request, final AsyncHandler<CreateProjectRequest, CreateProjectResult> asyncHandler) {
        final CreateProjectRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateProjectResult>(){

            @Override
            public CreateProjectResult call() throws Exception {
                CreateProjectResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeCreateProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUserProfileResult> createUserProfileAsync(CreateUserProfileRequest request) {
        return this.createUserProfileAsync(request, null);
    }

    @Override
    public Future<CreateUserProfileResult> createUserProfileAsync(CreateUserProfileRequest request, final AsyncHandler<CreateUserProfileRequest, CreateUserProfileResult> asyncHandler) {
        final CreateUserProfileRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateUserProfileResult>(){

            @Override
            public CreateUserProfileResult call() throws Exception {
                CreateUserProfileResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeCreateUserProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request) {
        return this.deleteProjectAsync(request, null);
    }

    @Override
    public Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request, final AsyncHandler<DeleteProjectRequest, DeleteProjectResult> asyncHandler) {
        final DeleteProjectRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteProjectResult>(){

            @Override
            public DeleteProjectResult call() throws Exception {
                DeleteProjectResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeDeleteProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserProfileResult> deleteUserProfileAsync(DeleteUserProfileRequest request) {
        return this.deleteUserProfileAsync(request, null);
    }

    @Override
    public Future<DeleteUserProfileResult> deleteUserProfileAsync(DeleteUserProfileRequest request, final AsyncHandler<DeleteUserProfileRequest, DeleteUserProfileResult> asyncHandler) {
        final DeleteUserProfileRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteUserProfileResult>(){

            @Override
            public DeleteUserProfileResult call() throws Exception {
                DeleteUserProfileResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeDeleteUserProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeProjectResult> describeProjectAsync(DescribeProjectRequest request) {
        return this.describeProjectAsync(request, null);
    }

    @Override
    public Future<DescribeProjectResult> describeProjectAsync(DescribeProjectRequest request, final AsyncHandler<DescribeProjectRequest, DescribeProjectResult> asyncHandler) {
        final DescribeProjectRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeProjectResult>(){

            @Override
            public DescribeProjectResult call() throws Exception {
                DescribeProjectResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeDescribeProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserProfileResult> describeUserProfileAsync(DescribeUserProfileRequest request) {
        return this.describeUserProfileAsync(request, null);
    }

    @Override
    public Future<DescribeUserProfileResult> describeUserProfileAsync(DescribeUserProfileRequest request, final AsyncHandler<DescribeUserProfileRequest, DescribeUserProfileResult> asyncHandler) {
        final DescribeUserProfileRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeUserProfileResult>(){

            @Override
            public DescribeUserProfileResult call() throws Exception {
                DescribeUserProfileResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeDescribeUserProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateTeamMemberResult> disassociateTeamMemberAsync(DisassociateTeamMemberRequest request) {
        return this.disassociateTeamMemberAsync(request, null);
    }

    @Override
    public Future<DisassociateTeamMemberResult> disassociateTeamMemberAsync(DisassociateTeamMemberRequest request, final AsyncHandler<DisassociateTeamMemberRequest, DisassociateTeamMemberResult> asyncHandler) {
        final DisassociateTeamMemberRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateTeamMemberResult>(){

            @Override
            public DisassociateTeamMemberResult call() throws Exception {
                DisassociateTeamMemberResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeDisassociateTeamMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request) {
        return this.listProjectsAsync(request, null);
    }

    @Override
    public Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request, final AsyncHandler<ListProjectsRequest, ListProjectsResult> asyncHandler) {
        final ListProjectsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListProjectsResult>(){

            @Override
            public ListProjectsResult call() throws Exception {
                ListProjectsResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeListProjects(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListResourcesResult> listResourcesAsync(ListResourcesRequest request) {
        return this.listResourcesAsync(request, null);
    }

    @Override
    public Future<ListResourcesResult> listResourcesAsync(ListResourcesRequest request, final AsyncHandler<ListResourcesRequest, ListResourcesResult> asyncHandler) {
        final ListResourcesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListResourcesResult>(){

            @Override
            public ListResourcesResult call() throws Exception {
                ListResourcesResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeListResources(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTeamMembersResult> listTeamMembersAsync(ListTeamMembersRequest request) {
        return this.listTeamMembersAsync(request, null);
    }

    @Override
    public Future<ListTeamMembersResult> listTeamMembersAsync(ListTeamMembersRequest request, final AsyncHandler<ListTeamMembersRequest, ListTeamMembersResult> asyncHandler) {
        final ListTeamMembersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTeamMembersResult>(){

            @Override
            public ListTeamMembersResult call() throws Exception {
                ListTeamMembersResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeListTeamMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUserProfilesResult> listUserProfilesAsync(ListUserProfilesRequest request) {
        return this.listUserProfilesAsync(request, null);
    }

    @Override
    public Future<ListUserProfilesResult> listUserProfilesAsync(ListUserProfilesRequest request, final AsyncHandler<ListUserProfilesRequest, ListUserProfilesResult> asyncHandler) {
        final ListUserProfilesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListUserProfilesResult>(){

            @Override
            public ListUserProfilesResult call() throws Exception {
                ListUserProfilesResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeListUserProfiles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request) {
        return this.updateProjectAsync(request, null);
    }

    @Override
    public Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request, final AsyncHandler<UpdateProjectRequest, UpdateProjectResult> asyncHandler) {
        final UpdateProjectRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateProjectResult>(){

            @Override
            public UpdateProjectResult call() throws Exception {
                UpdateProjectResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeUpdateProject(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateTeamMemberResult> updateTeamMemberAsync(UpdateTeamMemberRequest request) {
        return this.updateTeamMemberAsync(request, null);
    }

    @Override
    public Future<UpdateTeamMemberResult> updateTeamMemberAsync(UpdateTeamMemberRequest request, final AsyncHandler<UpdateTeamMemberRequest, UpdateTeamMemberResult> asyncHandler) {
        final UpdateTeamMemberRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateTeamMemberResult>(){

            @Override
            public UpdateTeamMemberResult call() throws Exception {
                UpdateTeamMemberResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeUpdateTeamMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserProfileResult> updateUserProfileAsync(UpdateUserProfileRequest request) {
        return this.updateUserProfileAsync(request, null);
    }

    @Override
    public Future<UpdateUserProfileResult> updateUserProfileAsync(UpdateUserProfileRequest request, final AsyncHandler<UpdateUserProfileRequest, UpdateUserProfileResult> asyncHandler) {
        final UpdateUserProfileRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateUserProfileResult>(){

            @Override
            public UpdateUserProfileResult call() throws Exception {
                UpdateUserProfileResult result = null;
                try {
                    result = AWSCodeStarAsyncClient.this.executeUpdateUserProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

