/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.BlockDeviceMapping;
import com.amazonaws.services.autoscaling.model.CreateLaunchConfigurationRequest;
import com.amazonaws.services.autoscaling.model.Ebs;
import com.amazonaws.services.autoscaling.model.InstanceMonitoring;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateLaunchConfigurationRequestMarshaller
implements Marshaller<Request<CreateLaunchConfigurationRequest>, CreateLaunchConfigurationRequest> {
    @Override
    public Request<CreateLaunchConfigurationRequest> marshall(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) {
        InstanceMonitoring instanceMonitoring;
        SdkInternalList blockDeviceMappingsList;
        SdkInternalList classicLinkVPCSecurityGroupsList;
        SdkInternalList securityGroupsList;
        if (createLaunchConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateLaunchConfigurationRequest> request = new DefaultRequest<CreateLaunchConfigurationRequest>(createLaunchConfigurationRequest, "AmazonAutoScaling");
        request.addParameter("Action", "CreateLaunchConfiguration");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLaunchConfigurationRequest.getLaunchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringUtils.fromString(createLaunchConfigurationRequest.getLaunchConfigurationName()));
        }
        if (createLaunchConfigurationRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(createLaunchConfigurationRequest.getImageId()));
        }
        if (createLaunchConfigurationRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString(createLaunchConfigurationRequest.getKeyName()));
        }
        if (!(securityGroupsList = (SdkInternalList)createLaunchConfigurationRequest.getSecurityGroups()).isEmpty() || !securityGroupsList.isAutoConstruct()) {
            int securityGroupsListIndex = 1;
            for (Object securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringUtils.fromString((String)securityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (createLaunchConfigurationRequest.getClassicLinkVPCId() != null) {
            request.addParameter("ClassicLinkVPCId", StringUtils.fromString(createLaunchConfigurationRequest.getClassicLinkVPCId()));
        }
        if (!(classicLinkVPCSecurityGroupsList = (SdkInternalList)createLaunchConfigurationRequest.getClassicLinkVPCSecurityGroups()).isEmpty() || !classicLinkVPCSecurityGroupsList.isAutoConstruct()) {
            int classicLinkVPCSecurityGroupsListIndex = 1;
            for (String classicLinkVPCSecurityGroupsListValue : classicLinkVPCSecurityGroupsList) {
                if (classicLinkVPCSecurityGroupsListValue != null) {
                    request.addParameter("ClassicLinkVPCSecurityGroups.member." + classicLinkVPCSecurityGroupsListIndex, StringUtils.fromString(classicLinkVPCSecurityGroupsListValue));
                }
                ++classicLinkVPCSecurityGroupsListIndex;
            }
        }
        if (createLaunchConfigurationRequest.getUserData() != null) {
            request.addParameter("UserData", StringUtils.fromString(createLaunchConfigurationRequest.getUserData()));
        }
        if (createLaunchConfigurationRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(createLaunchConfigurationRequest.getInstanceId()));
        }
        if (createLaunchConfigurationRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString(createLaunchConfigurationRequest.getInstanceType()));
        }
        if (createLaunchConfigurationRequest.getKernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString(createLaunchConfigurationRequest.getKernelId()));
        }
        if (createLaunchConfigurationRequest.getRamdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString(createLaunchConfigurationRequest.getRamdiskId()));
        }
        if (!(blockDeviceMappingsList = (SdkInternalList)createLaunchConfigurationRequest.getBlockDeviceMappings()).isEmpty() || !blockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                Ebs ebs;
                if (blockDeviceMappingsListValue.getVirtualName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString(blockDeviceMappingsListValue.getVirtualName()));
                }
                if (blockDeviceMappingsListValue.getDeviceName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString(blockDeviceMappingsListValue.getDeviceName()));
                }
                if ((ebs = blockDeviceMappingsListValue.getEbs()) != null) {
                    if (ebs.getSnapshotId() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString(ebs.getSnapshotId()));
                    }
                    if (ebs.getVolumeSize() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger(ebs.getVolumeSize()));
                    }
                    if (ebs.getVolumeType() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString(ebs.getVolumeType()));
                    }
                    if (ebs.getDeleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.getDeleteOnTermination()));
                    }
                    if (ebs.getIops() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger(ebs.getIops()));
                    }
                    if (ebs.getEncrypted() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean(ebs.getEncrypted()));
                    }
                }
                if (blockDeviceMappingsListValue.getNoDevice() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromBoolean(blockDeviceMappingsListValue.getNoDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if ((instanceMonitoring = createLaunchConfigurationRequest.getInstanceMonitoring()) != null && instanceMonitoring.getEnabled() != null) {
            request.addParameter("InstanceMonitoring.Enabled", StringUtils.fromBoolean(instanceMonitoring.getEnabled()));
        }
        if (createLaunchConfigurationRequest.getSpotPrice() != null) {
            request.addParameter("SpotPrice", StringUtils.fromString(createLaunchConfigurationRequest.getSpotPrice()));
        }
        if (createLaunchConfigurationRequest.getIamInstanceProfile() != null) {
            request.addParameter("IamInstanceProfile", StringUtils.fromString(createLaunchConfigurationRequest.getIamInstanceProfile()));
        }
        if (createLaunchConfigurationRequest.getEbsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean(createLaunchConfigurationRequest.getEbsOptimized()));
        }
        if (createLaunchConfigurationRequest.getAssociatePublicIpAddress() != null) {
            request.addParameter("AssociatePublicIpAddress", StringUtils.fromBoolean(createLaunchConfigurationRequest.getAssociatePublicIpAddress()));
        }
        if (createLaunchConfigurationRequest.getPlacementTenancy() != null) {
            request.addParameter("PlacementTenancy", StringUtils.fromString(createLaunchConfigurationRequest.getPlacementTenancy()));
        }
        return request;
    }
}

