/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteSecurityGroupRequestMarshaller
implements Marshaller<Request<DeleteSecurityGroupRequest>, DeleteSecurityGroupRequest> {
    @Override
    public Request<DeleteSecurityGroupRequest> marshall(DeleteSecurityGroupRequest deleteSecurityGroupRequest) {
        if (deleteSecurityGroupRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteSecurityGroupRequest> request = new DefaultRequest<DeleteSecurityGroupRequest>(deleteSecurityGroupRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteSecurityGroup");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteSecurityGroupRequest.getGroupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString(deleteSecurityGroupRequest.getGroupName()));
        }
        if (deleteSecurityGroupRequest.getGroupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString(deleteSecurityGroupRequest.getGroupId()));
        }
        return request;
    }
}

