/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.devicefarm.model.Run;
import com.amazonaws.services.devicefarm.model.transform.CountersJsonMarshaller;
import com.amazonaws.services.devicefarm.model.transform.DeviceMinutesJsonMarshaller;

public class RunJsonMarshaller {
    private static RunJsonMarshaller instance;

    public void marshall(Run run, StructuredJsonGenerator jsonGenerator) {
        if (run == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (run.getArn() != null) {
                jsonGenerator.writeFieldName("arn").writeValue(run.getArn());
            }
            if (run.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(run.getName());
            }
            if (run.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(run.getType());
            }
            if (run.getPlatform() != null) {
                jsonGenerator.writeFieldName("platform").writeValue(run.getPlatform());
            }
            if (run.getCreated() != null) {
                jsonGenerator.writeFieldName("created").writeValue(run.getCreated());
            }
            if (run.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(run.getStatus());
            }
            if (run.getResult() != null) {
                jsonGenerator.writeFieldName("result").writeValue(run.getResult());
            }
            if (run.getStarted() != null) {
                jsonGenerator.writeFieldName("started").writeValue(run.getStarted());
            }
            if (run.getStopped() != null) {
                jsonGenerator.writeFieldName("stopped").writeValue(run.getStopped());
            }
            if (run.getCounters() != null) {
                jsonGenerator.writeFieldName("counters");
                CountersJsonMarshaller.getInstance().marshall(run.getCounters(), jsonGenerator);
            }
            if (run.getMessage() != null) {
                jsonGenerator.writeFieldName("message").writeValue(run.getMessage());
            }
            if (run.getTotalJobs() != null) {
                jsonGenerator.writeFieldName("totalJobs").writeValue(run.getTotalJobs());
            }
            if (run.getCompletedJobs() != null) {
                jsonGenerator.writeFieldName("completedJobs").writeValue(run.getCompletedJobs());
            }
            if (run.getBillingMethod() != null) {
                jsonGenerator.writeFieldName("billingMethod").writeValue(run.getBillingMethod());
            }
            if (run.getDeviceMinutes() != null) {
                jsonGenerator.writeFieldName("deviceMinutes");
                DeviceMinutesJsonMarshaller.getInstance().marshall(run.getDeviceMinutes(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RunJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RunJsonMarshaller();
        }
        return instance;
    }
}

