/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cognitosync.model.BulkPublishRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class BulkPublishRequestMarshaller
implements Marshaller<Request<BulkPublishRequest>, BulkPublishRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public BulkPublishRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<BulkPublishRequest> marshall(BulkPublishRequest bulkPublishRequest) {
        if (bulkPublishRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BulkPublishRequest> request = new DefaultRequest<BulkPublishRequest>(bulkPublishRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/bulkpublish";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", bulkPublishRequest.getIdentityPoolId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(bulkPublishRequest.getIdentityPoolId()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

