/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.EC2CredentialsFetcher;
import com.amazonaws.internal.CredentialsEndpointProvider;
import com.amazonaws.internal.EC2CredentialsUtils;
import com.amazonaws.util.EC2MetadataUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstanceProfileCredentialsProvider
implements AWSCredentialsProvider {
    private static final Log LOG = LogFactory.getLog(InstanceProfileCredentialsProvider.class);
    private static final int ASYNC_REFRESH_INTERVAL_TIME_MINUTES = 1;
    private final EC2CredentialsFetcher credentialsFetcher = new EC2CredentialsFetcher(new InstanceMetadataCredentialsEndpointProvider());
    private volatile ScheduledExecutorService executor;

    public InstanceProfileCredentialsProvider() {
        this(false);
    }

    public InstanceProfileCredentialsProvider(boolean refreshCredentialsAsync) {
        if (refreshCredentialsAsync) {
            this.executor = Executors.newScheduledThreadPool(1);
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        InstanceProfileCredentialsProvider.this.credentialsFetcher.getCredentials();
                    }
                    catch (AmazonClientException ace) {
                        InstanceProfileCredentialsProvider.this.handleError(ace);
                    }
                    catch (RuntimeException re) {
                        InstanceProfileCredentialsProvider.this.handleError(re);
                    }
                    catch (Error e) {
                        InstanceProfileCredentialsProvider.this.handleError(e);
                    }
                }
            }, 0L, 1L, TimeUnit.MINUTES);
        }
    }

    private void handleError(Throwable t) {
        this.refresh();
        LOG.error((Object)t.getMessage(), t);
    }

    protected void finalize() throws Throwable {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.credentialsFetcher.getCredentials();
    }

    @Override
    public void refresh() {
        this.credentialsFetcher.refresh();
    }

    private static class InstanceMetadataCredentialsEndpointProvider
    implements CredentialsEndpointProvider {
        private InstanceMetadataCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() throws URISyntaxException, IOException {
            String host = EC2MetadataUtils.getHostAddressForEC2MetadataService();
            String securityCredentialsList = EC2CredentialsUtils.readResource(new URI(host + "/latest/meta-data/iam/security-credentials/"));
            String[] securityCredentials = securityCredentialsList.trim().split("\n");
            if (securityCredentials.length == 0) {
                throw new AmazonClientException("Unable to load credentials path");
            }
            return new URI(host + "/latest/meta-data/iam/security-credentials/" + securityCredentials[0]);
        }
    }
}

