/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.waf.AWSWAFAsync;
import com.amazonaws.services.waf.AWSWAFClient;
import com.amazonaws.services.waf.model.CreateByteMatchSetRequest;
import com.amazonaws.services.waf.model.CreateByteMatchSetResult;
import com.amazonaws.services.waf.model.CreateIPSetRequest;
import com.amazonaws.services.waf.model.CreateIPSetResult;
import com.amazonaws.services.waf.model.CreateRuleRequest;
import com.amazonaws.services.waf.model.CreateRuleResult;
import com.amazonaws.services.waf.model.CreateSizeConstraintSetRequest;
import com.amazonaws.services.waf.model.CreateSizeConstraintSetResult;
import com.amazonaws.services.waf.model.CreateSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.CreateSqlInjectionMatchSetResult;
import com.amazonaws.services.waf.model.CreateWebACLRequest;
import com.amazonaws.services.waf.model.CreateWebACLResult;
import com.amazonaws.services.waf.model.CreateXssMatchSetRequest;
import com.amazonaws.services.waf.model.CreateXssMatchSetResult;
import com.amazonaws.services.waf.model.DeleteByteMatchSetRequest;
import com.amazonaws.services.waf.model.DeleteByteMatchSetResult;
import com.amazonaws.services.waf.model.DeleteIPSetRequest;
import com.amazonaws.services.waf.model.DeleteIPSetResult;
import com.amazonaws.services.waf.model.DeleteRuleRequest;
import com.amazonaws.services.waf.model.DeleteRuleResult;
import com.amazonaws.services.waf.model.DeleteSizeConstraintSetRequest;
import com.amazonaws.services.waf.model.DeleteSizeConstraintSetResult;
import com.amazonaws.services.waf.model.DeleteSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.DeleteSqlInjectionMatchSetResult;
import com.amazonaws.services.waf.model.DeleteWebACLRequest;
import com.amazonaws.services.waf.model.DeleteWebACLResult;
import com.amazonaws.services.waf.model.DeleteXssMatchSetRequest;
import com.amazonaws.services.waf.model.DeleteXssMatchSetResult;
import com.amazonaws.services.waf.model.GetByteMatchSetRequest;
import com.amazonaws.services.waf.model.GetByteMatchSetResult;
import com.amazonaws.services.waf.model.GetChangeTokenRequest;
import com.amazonaws.services.waf.model.GetChangeTokenResult;
import com.amazonaws.services.waf.model.GetChangeTokenStatusRequest;
import com.amazonaws.services.waf.model.GetChangeTokenStatusResult;
import com.amazonaws.services.waf.model.GetIPSetRequest;
import com.amazonaws.services.waf.model.GetIPSetResult;
import com.amazonaws.services.waf.model.GetRuleRequest;
import com.amazonaws.services.waf.model.GetRuleResult;
import com.amazonaws.services.waf.model.GetSampledRequestsRequest;
import com.amazonaws.services.waf.model.GetSampledRequestsResult;
import com.amazonaws.services.waf.model.GetSizeConstraintSetRequest;
import com.amazonaws.services.waf.model.GetSizeConstraintSetResult;
import com.amazonaws.services.waf.model.GetSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.GetSqlInjectionMatchSetResult;
import com.amazonaws.services.waf.model.GetWebACLRequest;
import com.amazonaws.services.waf.model.GetWebACLResult;
import com.amazonaws.services.waf.model.GetXssMatchSetRequest;
import com.amazonaws.services.waf.model.GetXssMatchSetResult;
import com.amazonaws.services.waf.model.ListByteMatchSetsRequest;
import com.amazonaws.services.waf.model.ListByteMatchSetsResult;
import com.amazonaws.services.waf.model.ListIPSetsRequest;
import com.amazonaws.services.waf.model.ListIPSetsResult;
import com.amazonaws.services.waf.model.ListRulesRequest;
import com.amazonaws.services.waf.model.ListRulesResult;
import com.amazonaws.services.waf.model.ListSizeConstraintSetsRequest;
import com.amazonaws.services.waf.model.ListSizeConstraintSetsResult;
import com.amazonaws.services.waf.model.ListSqlInjectionMatchSetsRequest;
import com.amazonaws.services.waf.model.ListSqlInjectionMatchSetsResult;
import com.amazonaws.services.waf.model.ListWebACLsRequest;
import com.amazonaws.services.waf.model.ListWebACLsResult;
import com.amazonaws.services.waf.model.ListXssMatchSetsRequest;
import com.amazonaws.services.waf.model.ListXssMatchSetsResult;
import com.amazonaws.services.waf.model.UpdateByteMatchSetRequest;
import com.amazonaws.services.waf.model.UpdateByteMatchSetResult;
import com.amazonaws.services.waf.model.UpdateIPSetRequest;
import com.amazonaws.services.waf.model.UpdateIPSetResult;
import com.amazonaws.services.waf.model.UpdateRuleRequest;
import com.amazonaws.services.waf.model.UpdateRuleResult;
import com.amazonaws.services.waf.model.UpdateSizeConstraintSetRequest;
import com.amazonaws.services.waf.model.UpdateSizeConstraintSetResult;
import com.amazonaws.services.waf.model.UpdateSqlInjectionMatchSetRequest;
import com.amazonaws.services.waf.model.UpdateSqlInjectionMatchSetResult;
import com.amazonaws.services.waf.model.UpdateWebACLRequest;
import com.amazonaws.services.waf.model.UpdateWebACLResult;
import com.amazonaws.services.waf.model.UpdateXssMatchSetRequest;
import com.amazonaws.services.waf.model.UpdateXssMatchSetResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSWAFAsyncClient
extends AWSWAFClient
implements AWSWAFAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSWAFAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSWAFAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSWAFAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSWAFAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSWAFAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSWAFAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSWAFAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSWAFAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSWAFAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSWAFAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateByteMatchSetResult> createByteMatchSetAsync(CreateByteMatchSetRequest request) {
        return this.createByteMatchSetAsync(request, null);
    }

    @Override
    public Future<CreateByteMatchSetResult> createByteMatchSetAsync(final CreateByteMatchSetRequest request, final AsyncHandler<CreateByteMatchSetRequest, CreateByteMatchSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateByteMatchSetResult>(){

            @Override
            public CreateByteMatchSetResult call() throws Exception {
                CreateByteMatchSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.createByteMatchSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateIPSetResult> createIPSetAsync(CreateIPSetRequest request) {
        return this.createIPSetAsync(request, null);
    }

    @Override
    public Future<CreateIPSetResult> createIPSetAsync(final CreateIPSetRequest request, final AsyncHandler<CreateIPSetRequest, CreateIPSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateIPSetResult>(){

            @Override
            public CreateIPSetResult call() throws Exception {
                CreateIPSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.createIPSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRuleResult> createRuleAsync(CreateRuleRequest request) {
        return this.createRuleAsync(request, null);
    }

    @Override
    public Future<CreateRuleResult> createRuleAsync(final CreateRuleRequest request, final AsyncHandler<CreateRuleRequest, CreateRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateRuleResult>(){

            @Override
            public CreateRuleResult call() throws Exception {
                CreateRuleResult result;
                try {
                    result = AWSWAFAsyncClient.this.createRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSizeConstraintSetResult> createSizeConstraintSetAsync(CreateSizeConstraintSetRequest request) {
        return this.createSizeConstraintSetAsync(request, null);
    }

    @Override
    public Future<CreateSizeConstraintSetResult> createSizeConstraintSetAsync(final CreateSizeConstraintSetRequest request, final AsyncHandler<CreateSizeConstraintSetRequest, CreateSizeConstraintSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateSizeConstraintSetResult>(){

            @Override
            public CreateSizeConstraintSetResult call() throws Exception {
                CreateSizeConstraintSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.createSizeConstraintSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSqlInjectionMatchSetResult> createSqlInjectionMatchSetAsync(CreateSqlInjectionMatchSetRequest request) {
        return this.createSqlInjectionMatchSetAsync(request, null);
    }

    @Override
    public Future<CreateSqlInjectionMatchSetResult> createSqlInjectionMatchSetAsync(final CreateSqlInjectionMatchSetRequest request, final AsyncHandler<CreateSqlInjectionMatchSetRequest, CreateSqlInjectionMatchSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateSqlInjectionMatchSetResult>(){

            @Override
            public CreateSqlInjectionMatchSetResult call() throws Exception {
                CreateSqlInjectionMatchSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.createSqlInjectionMatchSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateWebACLResult> createWebACLAsync(CreateWebACLRequest request) {
        return this.createWebACLAsync(request, null);
    }

    @Override
    public Future<CreateWebACLResult> createWebACLAsync(final CreateWebACLRequest request, final AsyncHandler<CreateWebACLRequest, CreateWebACLResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateWebACLResult>(){

            @Override
            public CreateWebACLResult call() throws Exception {
                CreateWebACLResult result;
                try {
                    result = AWSWAFAsyncClient.this.createWebACL(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateXssMatchSetResult> createXssMatchSetAsync(CreateXssMatchSetRequest request) {
        return this.createXssMatchSetAsync(request, null);
    }

    @Override
    public Future<CreateXssMatchSetResult> createXssMatchSetAsync(final CreateXssMatchSetRequest request, final AsyncHandler<CreateXssMatchSetRequest, CreateXssMatchSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateXssMatchSetResult>(){

            @Override
            public CreateXssMatchSetResult call() throws Exception {
                CreateXssMatchSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.createXssMatchSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteByteMatchSetResult> deleteByteMatchSetAsync(DeleteByteMatchSetRequest request) {
        return this.deleteByteMatchSetAsync(request, null);
    }

    @Override
    public Future<DeleteByteMatchSetResult> deleteByteMatchSetAsync(final DeleteByteMatchSetRequest request, final AsyncHandler<DeleteByteMatchSetRequest, DeleteByteMatchSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteByteMatchSetResult>(){

            @Override
            public DeleteByteMatchSetResult call() throws Exception {
                DeleteByteMatchSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.deleteByteMatchSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteIPSetResult> deleteIPSetAsync(DeleteIPSetRequest request) {
        return this.deleteIPSetAsync(request, null);
    }

    @Override
    public Future<DeleteIPSetResult> deleteIPSetAsync(final DeleteIPSetRequest request, final AsyncHandler<DeleteIPSetRequest, DeleteIPSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteIPSetResult>(){

            @Override
            public DeleteIPSetResult call() throws Exception {
                DeleteIPSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.deleteIPSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRuleResult> deleteRuleAsync(DeleteRuleRequest request) {
        return this.deleteRuleAsync(request, null);
    }

    @Override
    public Future<DeleteRuleResult> deleteRuleAsync(final DeleteRuleRequest request, final AsyncHandler<DeleteRuleRequest, DeleteRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteRuleResult>(){

            @Override
            public DeleteRuleResult call() throws Exception {
                DeleteRuleResult result;
                try {
                    result = AWSWAFAsyncClient.this.deleteRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSizeConstraintSetResult> deleteSizeConstraintSetAsync(DeleteSizeConstraintSetRequest request) {
        return this.deleteSizeConstraintSetAsync(request, null);
    }

    @Override
    public Future<DeleteSizeConstraintSetResult> deleteSizeConstraintSetAsync(final DeleteSizeConstraintSetRequest request, final AsyncHandler<DeleteSizeConstraintSetRequest, DeleteSizeConstraintSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteSizeConstraintSetResult>(){

            @Override
            public DeleteSizeConstraintSetResult call() throws Exception {
                DeleteSizeConstraintSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.deleteSizeConstraintSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSqlInjectionMatchSetResult> deleteSqlInjectionMatchSetAsync(DeleteSqlInjectionMatchSetRequest request) {
        return this.deleteSqlInjectionMatchSetAsync(request, null);
    }

    @Override
    public Future<DeleteSqlInjectionMatchSetResult> deleteSqlInjectionMatchSetAsync(final DeleteSqlInjectionMatchSetRequest request, final AsyncHandler<DeleteSqlInjectionMatchSetRequest, DeleteSqlInjectionMatchSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteSqlInjectionMatchSetResult>(){

            @Override
            public DeleteSqlInjectionMatchSetResult call() throws Exception {
                DeleteSqlInjectionMatchSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.deleteSqlInjectionMatchSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteWebACLResult> deleteWebACLAsync(DeleteWebACLRequest request) {
        return this.deleteWebACLAsync(request, null);
    }

    @Override
    public Future<DeleteWebACLResult> deleteWebACLAsync(final DeleteWebACLRequest request, final AsyncHandler<DeleteWebACLRequest, DeleteWebACLResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteWebACLResult>(){

            @Override
            public DeleteWebACLResult call() throws Exception {
                DeleteWebACLResult result;
                try {
                    result = AWSWAFAsyncClient.this.deleteWebACL(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteXssMatchSetResult> deleteXssMatchSetAsync(DeleteXssMatchSetRequest request) {
        return this.deleteXssMatchSetAsync(request, null);
    }

    @Override
    public Future<DeleteXssMatchSetResult> deleteXssMatchSetAsync(final DeleteXssMatchSetRequest request, final AsyncHandler<DeleteXssMatchSetRequest, DeleteXssMatchSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteXssMatchSetResult>(){

            @Override
            public DeleteXssMatchSetResult call() throws Exception {
                DeleteXssMatchSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.deleteXssMatchSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetByteMatchSetResult> getByteMatchSetAsync(GetByteMatchSetRequest request) {
        return this.getByteMatchSetAsync(request, null);
    }

    @Override
    public Future<GetByteMatchSetResult> getByteMatchSetAsync(final GetByteMatchSetRequest request, final AsyncHandler<GetByteMatchSetRequest, GetByteMatchSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetByteMatchSetResult>(){

            @Override
            public GetByteMatchSetResult call() throws Exception {
                GetByteMatchSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.getByteMatchSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetChangeTokenResult> getChangeTokenAsync(GetChangeTokenRequest request) {
        return this.getChangeTokenAsync(request, null);
    }

    @Override
    public Future<GetChangeTokenResult> getChangeTokenAsync(final GetChangeTokenRequest request, final AsyncHandler<GetChangeTokenRequest, GetChangeTokenResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetChangeTokenResult>(){

            @Override
            public GetChangeTokenResult call() throws Exception {
                GetChangeTokenResult result;
                try {
                    result = AWSWAFAsyncClient.this.getChangeToken(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetChangeTokenStatusResult> getChangeTokenStatusAsync(GetChangeTokenStatusRequest request) {
        return this.getChangeTokenStatusAsync(request, null);
    }

    @Override
    public Future<GetChangeTokenStatusResult> getChangeTokenStatusAsync(final GetChangeTokenStatusRequest request, final AsyncHandler<GetChangeTokenStatusRequest, GetChangeTokenStatusResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetChangeTokenStatusResult>(){

            @Override
            public GetChangeTokenStatusResult call() throws Exception {
                GetChangeTokenStatusResult result;
                try {
                    result = AWSWAFAsyncClient.this.getChangeTokenStatus(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetIPSetResult> getIPSetAsync(GetIPSetRequest request) {
        return this.getIPSetAsync(request, null);
    }

    @Override
    public Future<GetIPSetResult> getIPSetAsync(final GetIPSetRequest request, final AsyncHandler<GetIPSetRequest, GetIPSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetIPSetResult>(){

            @Override
            public GetIPSetResult call() throws Exception {
                GetIPSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.getIPSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRuleResult> getRuleAsync(GetRuleRequest request) {
        return this.getRuleAsync(request, null);
    }

    @Override
    public Future<GetRuleResult> getRuleAsync(final GetRuleRequest request, final AsyncHandler<GetRuleRequest, GetRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetRuleResult>(){

            @Override
            public GetRuleResult call() throws Exception {
                GetRuleResult result;
                try {
                    result = AWSWAFAsyncClient.this.getRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSampledRequestsResult> getSampledRequestsAsync(GetSampledRequestsRequest request) {
        return this.getSampledRequestsAsync(request, null);
    }

    @Override
    public Future<GetSampledRequestsResult> getSampledRequestsAsync(final GetSampledRequestsRequest request, final AsyncHandler<GetSampledRequestsRequest, GetSampledRequestsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSampledRequestsResult>(){

            @Override
            public GetSampledRequestsResult call() throws Exception {
                GetSampledRequestsResult result;
                try {
                    result = AWSWAFAsyncClient.this.getSampledRequests(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSizeConstraintSetResult> getSizeConstraintSetAsync(GetSizeConstraintSetRequest request) {
        return this.getSizeConstraintSetAsync(request, null);
    }

    @Override
    public Future<GetSizeConstraintSetResult> getSizeConstraintSetAsync(final GetSizeConstraintSetRequest request, final AsyncHandler<GetSizeConstraintSetRequest, GetSizeConstraintSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSizeConstraintSetResult>(){

            @Override
            public GetSizeConstraintSetResult call() throws Exception {
                GetSizeConstraintSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.getSizeConstraintSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSqlInjectionMatchSetResult> getSqlInjectionMatchSetAsync(GetSqlInjectionMatchSetRequest request) {
        return this.getSqlInjectionMatchSetAsync(request, null);
    }

    @Override
    public Future<GetSqlInjectionMatchSetResult> getSqlInjectionMatchSetAsync(final GetSqlInjectionMatchSetRequest request, final AsyncHandler<GetSqlInjectionMatchSetRequest, GetSqlInjectionMatchSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSqlInjectionMatchSetResult>(){

            @Override
            public GetSqlInjectionMatchSetResult call() throws Exception {
                GetSqlInjectionMatchSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.getSqlInjectionMatchSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetWebACLResult> getWebACLAsync(GetWebACLRequest request) {
        return this.getWebACLAsync(request, null);
    }

    @Override
    public Future<GetWebACLResult> getWebACLAsync(final GetWebACLRequest request, final AsyncHandler<GetWebACLRequest, GetWebACLResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetWebACLResult>(){

            @Override
            public GetWebACLResult call() throws Exception {
                GetWebACLResult result;
                try {
                    result = AWSWAFAsyncClient.this.getWebACL(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetXssMatchSetResult> getXssMatchSetAsync(GetXssMatchSetRequest request) {
        return this.getXssMatchSetAsync(request, null);
    }

    @Override
    public Future<GetXssMatchSetResult> getXssMatchSetAsync(final GetXssMatchSetRequest request, final AsyncHandler<GetXssMatchSetRequest, GetXssMatchSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetXssMatchSetResult>(){

            @Override
            public GetXssMatchSetResult call() throws Exception {
                GetXssMatchSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.getXssMatchSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListByteMatchSetsResult> listByteMatchSetsAsync(ListByteMatchSetsRequest request) {
        return this.listByteMatchSetsAsync(request, null);
    }

    @Override
    public Future<ListByteMatchSetsResult> listByteMatchSetsAsync(final ListByteMatchSetsRequest request, final AsyncHandler<ListByteMatchSetsRequest, ListByteMatchSetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListByteMatchSetsResult>(){

            @Override
            public ListByteMatchSetsResult call() throws Exception {
                ListByteMatchSetsResult result;
                try {
                    result = AWSWAFAsyncClient.this.listByteMatchSets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIPSetsResult> listIPSetsAsync(ListIPSetsRequest request) {
        return this.listIPSetsAsync(request, null);
    }

    @Override
    public Future<ListIPSetsResult> listIPSetsAsync(final ListIPSetsRequest request, final AsyncHandler<ListIPSetsRequest, ListIPSetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListIPSetsResult>(){

            @Override
            public ListIPSetsResult call() throws Exception {
                ListIPSetsResult result;
                try {
                    result = AWSWAFAsyncClient.this.listIPSets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRulesResult> listRulesAsync(ListRulesRequest request) {
        return this.listRulesAsync(request, null);
    }

    @Override
    public Future<ListRulesResult> listRulesAsync(final ListRulesRequest request, final AsyncHandler<ListRulesRequest, ListRulesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListRulesResult>(){

            @Override
            public ListRulesResult call() throws Exception {
                ListRulesResult result;
                try {
                    result = AWSWAFAsyncClient.this.listRules(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSizeConstraintSetsResult> listSizeConstraintSetsAsync(ListSizeConstraintSetsRequest request) {
        return this.listSizeConstraintSetsAsync(request, null);
    }

    @Override
    public Future<ListSizeConstraintSetsResult> listSizeConstraintSetsAsync(final ListSizeConstraintSetsRequest request, final AsyncHandler<ListSizeConstraintSetsRequest, ListSizeConstraintSetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListSizeConstraintSetsResult>(){

            @Override
            public ListSizeConstraintSetsResult call() throws Exception {
                ListSizeConstraintSetsResult result;
                try {
                    result = AWSWAFAsyncClient.this.listSizeConstraintSets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSqlInjectionMatchSetsResult> listSqlInjectionMatchSetsAsync(ListSqlInjectionMatchSetsRequest request) {
        return this.listSqlInjectionMatchSetsAsync(request, null);
    }

    @Override
    public Future<ListSqlInjectionMatchSetsResult> listSqlInjectionMatchSetsAsync(final ListSqlInjectionMatchSetsRequest request, final AsyncHandler<ListSqlInjectionMatchSetsRequest, ListSqlInjectionMatchSetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListSqlInjectionMatchSetsResult>(){

            @Override
            public ListSqlInjectionMatchSetsResult call() throws Exception {
                ListSqlInjectionMatchSetsResult result;
                try {
                    result = AWSWAFAsyncClient.this.listSqlInjectionMatchSets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListWebACLsResult> listWebACLsAsync(ListWebACLsRequest request) {
        return this.listWebACLsAsync(request, null);
    }

    @Override
    public Future<ListWebACLsResult> listWebACLsAsync(final ListWebACLsRequest request, final AsyncHandler<ListWebACLsRequest, ListWebACLsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListWebACLsResult>(){

            @Override
            public ListWebACLsResult call() throws Exception {
                ListWebACLsResult result;
                try {
                    result = AWSWAFAsyncClient.this.listWebACLs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListXssMatchSetsResult> listXssMatchSetsAsync(ListXssMatchSetsRequest request) {
        return this.listXssMatchSetsAsync(request, null);
    }

    @Override
    public Future<ListXssMatchSetsResult> listXssMatchSetsAsync(final ListXssMatchSetsRequest request, final AsyncHandler<ListXssMatchSetsRequest, ListXssMatchSetsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListXssMatchSetsResult>(){

            @Override
            public ListXssMatchSetsResult call() throws Exception {
                ListXssMatchSetsResult result;
                try {
                    result = AWSWAFAsyncClient.this.listXssMatchSets(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateByteMatchSetResult> updateByteMatchSetAsync(UpdateByteMatchSetRequest request) {
        return this.updateByteMatchSetAsync(request, null);
    }

    @Override
    public Future<UpdateByteMatchSetResult> updateByteMatchSetAsync(final UpdateByteMatchSetRequest request, final AsyncHandler<UpdateByteMatchSetRequest, UpdateByteMatchSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateByteMatchSetResult>(){

            @Override
            public UpdateByteMatchSetResult call() throws Exception {
                UpdateByteMatchSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.updateByteMatchSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateIPSetResult> updateIPSetAsync(UpdateIPSetRequest request) {
        return this.updateIPSetAsync(request, null);
    }

    @Override
    public Future<UpdateIPSetResult> updateIPSetAsync(final UpdateIPSetRequest request, final AsyncHandler<UpdateIPSetRequest, UpdateIPSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateIPSetResult>(){

            @Override
            public UpdateIPSetResult call() throws Exception {
                UpdateIPSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.updateIPSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRuleResult> updateRuleAsync(UpdateRuleRequest request) {
        return this.updateRuleAsync(request, null);
    }

    @Override
    public Future<UpdateRuleResult> updateRuleAsync(final UpdateRuleRequest request, final AsyncHandler<UpdateRuleRequest, UpdateRuleResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateRuleResult>(){

            @Override
            public UpdateRuleResult call() throws Exception {
                UpdateRuleResult result;
                try {
                    result = AWSWAFAsyncClient.this.updateRule(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSizeConstraintSetResult> updateSizeConstraintSetAsync(UpdateSizeConstraintSetRequest request) {
        return this.updateSizeConstraintSetAsync(request, null);
    }

    @Override
    public Future<UpdateSizeConstraintSetResult> updateSizeConstraintSetAsync(final UpdateSizeConstraintSetRequest request, final AsyncHandler<UpdateSizeConstraintSetRequest, UpdateSizeConstraintSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateSizeConstraintSetResult>(){

            @Override
            public UpdateSizeConstraintSetResult call() throws Exception {
                UpdateSizeConstraintSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.updateSizeConstraintSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateSqlInjectionMatchSetResult> updateSqlInjectionMatchSetAsync(UpdateSqlInjectionMatchSetRequest request) {
        return this.updateSqlInjectionMatchSetAsync(request, null);
    }

    @Override
    public Future<UpdateSqlInjectionMatchSetResult> updateSqlInjectionMatchSetAsync(final UpdateSqlInjectionMatchSetRequest request, final AsyncHandler<UpdateSqlInjectionMatchSetRequest, UpdateSqlInjectionMatchSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateSqlInjectionMatchSetResult>(){

            @Override
            public UpdateSqlInjectionMatchSetResult call() throws Exception {
                UpdateSqlInjectionMatchSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.updateSqlInjectionMatchSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateWebACLResult> updateWebACLAsync(UpdateWebACLRequest request) {
        return this.updateWebACLAsync(request, null);
    }

    @Override
    public Future<UpdateWebACLResult> updateWebACLAsync(final UpdateWebACLRequest request, final AsyncHandler<UpdateWebACLRequest, UpdateWebACLResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateWebACLResult>(){

            @Override
            public UpdateWebACLResult call() throws Exception {
                UpdateWebACLResult result;
                try {
                    result = AWSWAFAsyncClient.this.updateWebACL(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateXssMatchSetResult> updateXssMatchSetAsync(UpdateXssMatchSetRequest request) {
        return this.updateXssMatchSetAsync(request, null);
    }

    @Override
    public Future<UpdateXssMatchSetResult> updateXssMatchSetAsync(final UpdateXssMatchSetRequest request, final AsyncHandler<UpdateXssMatchSetRequest, UpdateXssMatchSetResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateXssMatchSetResult>(){

            @Override
            public UpdateXssMatchSetResult call() throws Exception {
                UpdateXssMatchSetResult result;
                try {
                    result = AWSWAFAsyncClient.this.updateXssMatchSet(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

