/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionInfo;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowExecutionJsonMarshaller;
import com.amazonaws.services.simpleworkflow.model.transform.WorkflowTypeJsonMarshaller;
import java.util.List;

public class WorkflowExecutionInfoJsonMarshaller {
    private static WorkflowExecutionInfoJsonMarshaller instance;

    public void marshall(WorkflowExecutionInfo workflowExecutionInfo, StructuredJsonGenerator jsonGenerator) {
        if (workflowExecutionInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> tagListList;
            jsonGenerator.writeStartObject();
            if (workflowExecutionInfo.getExecution() != null) {
                jsonGenerator.writeFieldName("execution");
                WorkflowExecutionJsonMarshaller.getInstance().marshall(workflowExecutionInfo.getExecution(), jsonGenerator);
            }
            if (workflowExecutionInfo.getWorkflowType() != null) {
                jsonGenerator.writeFieldName("workflowType");
                WorkflowTypeJsonMarshaller.getInstance().marshall(workflowExecutionInfo.getWorkflowType(), jsonGenerator);
            }
            if (workflowExecutionInfo.getStartTimestamp() != null) {
                jsonGenerator.writeFieldName("startTimestamp").writeValue(workflowExecutionInfo.getStartTimestamp());
            }
            if (workflowExecutionInfo.getCloseTimestamp() != null) {
                jsonGenerator.writeFieldName("closeTimestamp").writeValue(workflowExecutionInfo.getCloseTimestamp());
            }
            if (workflowExecutionInfo.getExecutionStatus() != null) {
                jsonGenerator.writeFieldName("executionStatus").writeValue(workflowExecutionInfo.getExecutionStatus());
            }
            if (workflowExecutionInfo.getCloseStatus() != null) {
                jsonGenerator.writeFieldName("closeStatus").writeValue(workflowExecutionInfo.getCloseStatus());
            }
            if (workflowExecutionInfo.getParent() != null) {
                jsonGenerator.writeFieldName("parent");
                WorkflowExecutionJsonMarshaller.getInstance().marshall(workflowExecutionInfo.getParent(), jsonGenerator);
            }
            if ((tagListList = workflowExecutionInfo.getTagList()) != null) {
                jsonGenerator.writeFieldName("tagList");
                jsonGenerator.writeStartArray();
                for (String tagListListValue : tagListList) {
                    if (tagListListValue == null) continue;
                    jsonGenerator.writeValue(tagListListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (workflowExecutionInfo.getCancelRequested() != null) {
                jsonGenerator.writeFieldName("cancelRequested").writeValue(workflowExecutionInfo.getCancelRequested());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WorkflowExecutionInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WorkflowExecutionInfoJsonMarshaller();
        }
        return instance;
    }
}

