/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.lambda.model.GetFunctionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetFunctionRequestMarshaller
implements Marshaller<Request<GetFunctionRequest>, GetFunctionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetFunctionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetFunctionRequest> marshall(GetFunctionRequest getFunctionRequest) {
        if (getFunctionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetFunctionRequest> request = new DefaultRequest<GetFunctionRequest>(getFunctionRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-03-31/functions/{FunctionName}";
        uriResourcePath = uriResourcePath.replace("{FunctionName}", getFunctionRequest.getFunctionName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getFunctionRequest.getFunctionName()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (getFunctionRequest.getQualifier() != null) {
            request.addParameter("Qualifier", StringUtils.fromString(getFunctionRequest.getQualifier()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

