/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteAccessKeyRequestMarshaller
implements Marshaller<Request<DeleteAccessKeyRequest>, DeleteAccessKeyRequest> {
    @Override
    public Request<DeleteAccessKeyRequest> marshall(DeleteAccessKeyRequest deleteAccessKeyRequest) {
        if (deleteAccessKeyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteAccessKeyRequest> request = new DefaultRequest<DeleteAccessKeyRequest>(deleteAccessKeyRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "DeleteAccessKey");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteAccessKeyRequest.getUserName() != null) {
            request.addParameter("UserName", StringUtils.fromString(deleteAccessKeyRequest.getUserName()));
        }
        if (deleteAccessKeyRequest.getAccessKeyId() != null) {
            request.addParameter("AccessKeyId", StringUtils.fromString(deleteAccessKeyRequest.getAccessKeyId()));
        }
        return request;
    }
}

