/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.TaskDefinition;
import com.amazonaws.services.ecs.model.Volume;
import com.amazonaws.services.ecs.model.transform.AttributeJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.ContainerDefinitionJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.VolumeJsonMarshaller;

public class TaskDefinitionJsonMarshaller {
    private static TaskDefinitionJsonMarshaller instance;

    public void marshall(TaskDefinition taskDefinition, StructuredJsonGenerator jsonGenerator) {
        if (taskDefinition == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList requiresAttributesList;
            SdkInternalList volumesList;
            SdkInternalList containerDefinitionsList;
            jsonGenerator.writeStartObject();
            if (taskDefinition.getTaskDefinitionArn() != null) {
                jsonGenerator.writeFieldName("taskDefinitionArn").writeValue(taskDefinition.getTaskDefinitionArn());
            }
            if (!(containerDefinitionsList = (SdkInternalList)taskDefinition.getContainerDefinitions()).isEmpty() || !containerDefinitionsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("containerDefinitions");
                jsonGenerator.writeStartArray();
                for (Object containerDefinitionsListValue : containerDefinitionsList) {
                    if (containerDefinitionsListValue == null) continue;
                    ContainerDefinitionJsonMarshaller.getInstance().marshall((ContainerDefinition)containerDefinitionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (taskDefinition.getFamily() != null) {
                jsonGenerator.writeFieldName("family").writeValue(taskDefinition.getFamily());
            }
            if (taskDefinition.getTaskRoleArn() != null) {
                jsonGenerator.writeFieldName("taskRoleArn").writeValue(taskDefinition.getTaskRoleArn());
            }
            if (taskDefinition.getRevision() != null) {
                jsonGenerator.writeFieldName("revision").writeValue(taskDefinition.getRevision());
            }
            if (!(volumesList = (SdkInternalList)taskDefinition.getVolumes()).isEmpty() || !volumesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("volumes");
                jsonGenerator.writeStartArray();
                for (Volume volumesListValue : volumesList) {
                    if (volumesListValue == null) continue;
                    VolumeJsonMarshaller.getInstance().marshall(volumesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (taskDefinition.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(taskDefinition.getStatus());
            }
            if (!(requiresAttributesList = (SdkInternalList)taskDefinition.getRequiresAttributes()).isEmpty() || !requiresAttributesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("requiresAttributes");
                jsonGenerator.writeStartArray();
                for (Attribute requiresAttributesListValue : requiresAttributesList) {
                    if (requiresAttributesListValue == null) continue;
                    AttributeJsonMarshaller.getInstance().marshall(requiresAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TaskDefinitionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TaskDefinitionJsonMarshaller();
        }
        return instance;
    }
}

