/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ConditionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Map;

public class QueryRequestMarshaller
implements Marshaller<Request<QueryRequest>, QueryRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public QueryRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<QueryRequest> marshall(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<QueryRequest> request = new DefaultRequest<QueryRequest>(queryRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.Query");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Map<String, AttributeValue> map;
            Map<String, String> map2;
            Map<String, AttributeValue> map3;
            Map<String, Condition> map4;
            Map<String, Condition> keyConditionsMap;
            List<String> attributesToGetList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (queryRequest.getTableName() != null) {
                jsonGenerator.writeFieldName("TableName").writeValue(queryRequest.getTableName());
            }
            if (queryRequest.getIndexName() != null) {
                jsonGenerator.writeFieldName("IndexName").writeValue(queryRequest.getIndexName());
            }
            if (queryRequest.getSelect() != null) {
                jsonGenerator.writeFieldName("Select").writeValue(queryRequest.getSelect());
            }
            if ((attributesToGetList = queryRequest.getAttributesToGet()) != null) {
                jsonGenerator.writeFieldName("AttributesToGet");
                jsonGenerator.writeStartArray();
                for (String string : attributesToGetList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if (queryRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(queryRequest.getLimit());
            }
            if (queryRequest.getConsistentRead() != null) {
                jsonGenerator.writeFieldName("ConsistentRead").writeValue(queryRequest.getConsistentRead());
            }
            if ((keyConditionsMap = queryRequest.getKeyConditions()) != null) {
                jsonGenerator.writeFieldName("KeyConditions");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Condition> entry : keyConditionsMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    ConditionJsonMarshaller.getInstance().marshall(entry.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if ((map4 = queryRequest.getQueryFilter()) != null) {
                jsonGenerator.writeFieldName("QueryFilter");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Condition> entry : map4.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    ConditionJsonMarshaller.getInstance().marshall(entry.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (queryRequest.getConditionalOperator() != null) {
                jsonGenerator.writeFieldName("ConditionalOperator").writeValue(queryRequest.getConditionalOperator());
            }
            if (queryRequest.getScanIndexForward() != null) {
                jsonGenerator.writeFieldName("ScanIndexForward").writeValue(queryRequest.getScanIndexForward());
            }
            if ((map3 = queryRequest.getExclusiveStartKey()) != null) {
                jsonGenerator.writeFieldName("ExclusiveStartKey");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> entry : map3.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(entry.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (queryRequest.getReturnConsumedCapacity() != null) {
                jsonGenerator.writeFieldName("ReturnConsumedCapacity").writeValue(queryRequest.getReturnConsumedCapacity());
            }
            if (queryRequest.getProjectionExpression() != null) {
                jsonGenerator.writeFieldName("ProjectionExpression").writeValue(queryRequest.getProjectionExpression());
            }
            if (queryRequest.getFilterExpression() != null) {
                jsonGenerator.writeFieldName("FilterExpression").writeValue(queryRequest.getFilterExpression());
            }
            if (queryRequest.getKeyConditionExpression() != null) {
                jsonGenerator.writeFieldName("KeyConditionExpression").writeValue(queryRequest.getKeyConditionExpression());
            }
            if ((map2 = queryRequest.getExpressionAttributeNames()) != null) {
                jsonGenerator.writeFieldName("ExpressionAttributeNames");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> entry : map2.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    jsonGenerator.writeValue(entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((map = queryRequest.getExpressionAttributeValues()) != null) {
                jsonGenerator.writeFieldName("ExpressionAttributeValues");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> entry : map.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(entry.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

