/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityAsync;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClient;
import com.amazonaws.services.cognitoidentity.model.CreateIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.CreateIdentityPoolResult;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentitiesRequest;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentitiesResult;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentityPoolResult;
import com.amazonaws.services.cognitoidentity.model.DescribeIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.DescribeIdentityPoolResult;
import com.amazonaws.services.cognitoidentity.model.DescribeIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.DescribeIdentityResult;
import com.amazonaws.services.cognitoidentity.model.GetCredentialsForIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.GetCredentialsForIdentityResult;
import com.amazonaws.services.cognitoidentity.model.GetIdRequest;
import com.amazonaws.services.cognitoidentity.model.GetIdResult;
import com.amazonaws.services.cognitoidentity.model.GetIdentityPoolRolesRequest;
import com.amazonaws.services.cognitoidentity.model.GetIdentityPoolRolesResult;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenForDeveloperIdentityResult;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenRequest;
import com.amazonaws.services.cognitoidentity.model.GetOpenIdTokenResult;
import com.amazonaws.services.cognitoidentity.model.ListIdentitiesRequest;
import com.amazonaws.services.cognitoidentity.model.ListIdentitiesResult;
import com.amazonaws.services.cognitoidentity.model.ListIdentityPoolsRequest;
import com.amazonaws.services.cognitoidentity.model.ListIdentityPoolsResult;
import com.amazonaws.services.cognitoidentity.model.LookupDeveloperIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.LookupDeveloperIdentityResult;
import com.amazonaws.services.cognitoidentity.model.MergeDeveloperIdentitiesRequest;
import com.amazonaws.services.cognitoidentity.model.MergeDeveloperIdentitiesResult;
import com.amazonaws.services.cognitoidentity.model.SetIdentityPoolRolesRequest;
import com.amazonaws.services.cognitoidentity.model.SetIdentityPoolRolesResult;
import com.amazonaws.services.cognitoidentity.model.UnlinkDeveloperIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.UnlinkDeveloperIdentityResult;
import com.amazonaws.services.cognitoidentity.model.UnlinkIdentityRequest;
import com.amazonaws.services.cognitoidentity.model.UnlinkIdentityResult;
import com.amazonaws.services.cognitoidentity.model.UpdateIdentityPoolRequest;
import com.amazonaws.services.cognitoidentity.model.UpdateIdentityPoolResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonCognitoIdentityAsyncClient
extends AmazonCognitoIdentityClient
implements AmazonCognitoIdentityAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonCognitoIdentityAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonCognitoIdentityAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AmazonCognitoIdentityAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonCognitoIdentityAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateIdentityPoolResult> createIdentityPoolAsync(CreateIdentityPoolRequest request) {
        return this.createIdentityPoolAsync(request, null);
    }

    @Override
    public Future<CreateIdentityPoolResult> createIdentityPoolAsync(final CreateIdentityPoolRequest request, final AsyncHandler<CreateIdentityPoolRequest, CreateIdentityPoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateIdentityPoolResult>(){

            @Override
            public CreateIdentityPoolResult call() throws Exception {
                CreateIdentityPoolResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.createIdentityPool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteIdentitiesResult> deleteIdentitiesAsync(DeleteIdentitiesRequest request) {
        return this.deleteIdentitiesAsync(request, null);
    }

    @Override
    public Future<DeleteIdentitiesResult> deleteIdentitiesAsync(final DeleteIdentitiesRequest request, final AsyncHandler<DeleteIdentitiesRequest, DeleteIdentitiesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteIdentitiesResult>(){

            @Override
            public DeleteIdentitiesResult call() throws Exception {
                DeleteIdentitiesResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.deleteIdentities(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteIdentityPoolResult> deleteIdentityPoolAsync(DeleteIdentityPoolRequest request) {
        return this.deleteIdentityPoolAsync(request, null);
    }

    @Override
    public Future<DeleteIdentityPoolResult> deleteIdentityPoolAsync(final DeleteIdentityPoolRequest request, final AsyncHandler<DeleteIdentityPoolRequest, DeleteIdentityPoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteIdentityPoolResult>(){

            @Override
            public DeleteIdentityPoolResult call() throws Exception {
                DeleteIdentityPoolResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.deleteIdentityPool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityResult> describeIdentityAsync(DescribeIdentityRequest request) {
        return this.describeIdentityAsync(request, null);
    }

    @Override
    public Future<DescribeIdentityResult> describeIdentityAsync(final DescribeIdentityRequest request, final AsyncHandler<DescribeIdentityRequest, DescribeIdentityResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeIdentityResult>(){

            @Override
            public DescribeIdentityResult call() throws Exception {
                DescribeIdentityResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.describeIdentity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeIdentityPoolResult> describeIdentityPoolAsync(DescribeIdentityPoolRequest request) {
        return this.describeIdentityPoolAsync(request, null);
    }

    @Override
    public Future<DescribeIdentityPoolResult> describeIdentityPoolAsync(final DescribeIdentityPoolRequest request, final AsyncHandler<DescribeIdentityPoolRequest, DescribeIdentityPoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeIdentityPoolResult>(){

            @Override
            public DescribeIdentityPoolResult call() throws Exception {
                DescribeIdentityPoolResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.describeIdentityPool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCredentialsForIdentityResult> getCredentialsForIdentityAsync(GetCredentialsForIdentityRequest request) {
        return this.getCredentialsForIdentityAsync(request, null);
    }

    @Override
    public Future<GetCredentialsForIdentityResult> getCredentialsForIdentityAsync(final GetCredentialsForIdentityRequest request, final AsyncHandler<GetCredentialsForIdentityRequest, GetCredentialsForIdentityResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCredentialsForIdentityResult>(){

            @Override
            public GetCredentialsForIdentityResult call() throws Exception {
                GetCredentialsForIdentityResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.getCredentialsForIdentity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetIdResult> getIdAsync(GetIdRequest request) {
        return this.getIdAsync(request, null);
    }

    @Override
    public Future<GetIdResult> getIdAsync(final GetIdRequest request, final AsyncHandler<GetIdRequest, GetIdResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetIdResult>(){

            @Override
            public GetIdResult call() throws Exception {
                GetIdResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.getId(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetIdentityPoolRolesResult> getIdentityPoolRolesAsync(GetIdentityPoolRolesRequest request) {
        return this.getIdentityPoolRolesAsync(request, null);
    }

    @Override
    public Future<GetIdentityPoolRolesResult> getIdentityPoolRolesAsync(final GetIdentityPoolRolesRequest request, final AsyncHandler<GetIdentityPoolRolesRequest, GetIdentityPoolRolesResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetIdentityPoolRolesResult>(){

            @Override
            public GetIdentityPoolRolesResult call() throws Exception {
                GetIdentityPoolRolesResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.getIdentityPoolRoles(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOpenIdTokenResult> getOpenIdTokenAsync(GetOpenIdTokenRequest request) {
        return this.getOpenIdTokenAsync(request, null);
    }

    @Override
    public Future<GetOpenIdTokenResult> getOpenIdTokenAsync(final GetOpenIdTokenRequest request, final AsyncHandler<GetOpenIdTokenRequest, GetOpenIdTokenResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetOpenIdTokenResult>(){

            @Override
            public GetOpenIdTokenResult call() throws Exception {
                GetOpenIdTokenResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.getOpenIdToken(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetOpenIdTokenForDeveloperIdentityResult> getOpenIdTokenForDeveloperIdentityAsync(GetOpenIdTokenForDeveloperIdentityRequest request) {
        return this.getOpenIdTokenForDeveloperIdentityAsync(request, null);
    }

    @Override
    public Future<GetOpenIdTokenForDeveloperIdentityResult> getOpenIdTokenForDeveloperIdentityAsync(final GetOpenIdTokenForDeveloperIdentityRequest request, final AsyncHandler<GetOpenIdTokenForDeveloperIdentityRequest, GetOpenIdTokenForDeveloperIdentityResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetOpenIdTokenForDeveloperIdentityResult>(){

            @Override
            public GetOpenIdTokenForDeveloperIdentityResult call() throws Exception {
                GetOpenIdTokenForDeveloperIdentityResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.getOpenIdTokenForDeveloperIdentity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIdentitiesResult> listIdentitiesAsync(ListIdentitiesRequest request) {
        return this.listIdentitiesAsync(request, null);
    }

    @Override
    public Future<ListIdentitiesResult> listIdentitiesAsync(final ListIdentitiesRequest request, final AsyncHandler<ListIdentitiesRequest, ListIdentitiesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListIdentitiesResult>(){

            @Override
            public ListIdentitiesResult call() throws Exception {
                ListIdentitiesResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.listIdentities(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIdentityPoolsResult> listIdentityPoolsAsync(ListIdentityPoolsRequest request) {
        return this.listIdentityPoolsAsync(request, null);
    }

    @Override
    public Future<ListIdentityPoolsResult> listIdentityPoolsAsync(final ListIdentityPoolsRequest request, final AsyncHandler<ListIdentityPoolsRequest, ListIdentityPoolsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListIdentityPoolsResult>(){

            @Override
            public ListIdentityPoolsResult call() throws Exception {
                ListIdentityPoolsResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.listIdentityPools(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<LookupDeveloperIdentityResult> lookupDeveloperIdentityAsync(LookupDeveloperIdentityRequest request) {
        return this.lookupDeveloperIdentityAsync(request, null);
    }

    @Override
    public Future<LookupDeveloperIdentityResult> lookupDeveloperIdentityAsync(final LookupDeveloperIdentityRequest request, final AsyncHandler<LookupDeveloperIdentityRequest, LookupDeveloperIdentityResult> asyncHandler) {
        return this.executorService.submit(new Callable<LookupDeveloperIdentityResult>(){

            @Override
            public LookupDeveloperIdentityResult call() throws Exception {
                LookupDeveloperIdentityResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.lookupDeveloperIdentity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<MergeDeveloperIdentitiesResult> mergeDeveloperIdentitiesAsync(MergeDeveloperIdentitiesRequest request) {
        return this.mergeDeveloperIdentitiesAsync(request, null);
    }

    @Override
    public Future<MergeDeveloperIdentitiesResult> mergeDeveloperIdentitiesAsync(final MergeDeveloperIdentitiesRequest request, final AsyncHandler<MergeDeveloperIdentitiesRequest, MergeDeveloperIdentitiesResult> asyncHandler) {
        return this.executorService.submit(new Callable<MergeDeveloperIdentitiesResult>(){

            @Override
            public MergeDeveloperIdentitiesResult call() throws Exception {
                MergeDeveloperIdentitiesResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.mergeDeveloperIdentities(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetIdentityPoolRolesResult> setIdentityPoolRolesAsync(SetIdentityPoolRolesRequest request) {
        return this.setIdentityPoolRolesAsync(request, null);
    }

    @Override
    public Future<SetIdentityPoolRolesResult> setIdentityPoolRolesAsync(final SetIdentityPoolRolesRequest request, final AsyncHandler<SetIdentityPoolRolesRequest, SetIdentityPoolRolesResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetIdentityPoolRolesResult>(){

            @Override
            public SetIdentityPoolRolesResult call() throws Exception {
                SetIdentityPoolRolesResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.setIdentityPoolRoles(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnlinkDeveloperIdentityResult> unlinkDeveloperIdentityAsync(UnlinkDeveloperIdentityRequest request) {
        return this.unlinkDeveloperIdentityAsync(request, null);
    }

    @Override
    public Future<UnlinkDeveloperIdentityResult> unlinkDeveloperIdentityAsync(final UnlinkDeveloperIdentityRequest request, final AsyncHandler<UnlinkDeveloperIdentityRequest, UnlinkDeveloperIdentityResult> asyncHandler) {
        return this.executorService.submit(new Callable<UnlinkDeveloperIdentityResult>(){

            @Override
            public UnlinkDeveloperIdentityResult call() throws Exception {
                UnlinkDeveloperIdentityResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.unlinkDeveloperIdentity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UnlinkIdentityResult> unlinkIdentityAsync(UnlinkIdentityRequest request) {
        return this.unlinkIdentityAsync(request, null);
    }

    @Override
    public Future<UnlinkIdentityResult> unlinkIdentityAsync(final UnlinkIdentityRequest request, final AsyncHandler<UnlinkIdentityRequest, UnlinkIdentityResult> asyncHandler) {
        return this.executorService.submit(new Callable<UnlinkIdentityResult>(){

            @Override
            public UnlinkIdentityResult call() throws Exception {
                UnlinkIdentityResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.unlinkIdentity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateIdentityPoolResult> updateIdentityPoolAsync(UpdateIdentityPoolRequest request) {
        return this.updateIdentityPoolAsync(request, null);
    }

    @Override
    public Future<UpdateIdentityPoolResult> updateIdentityPoolAsync(final UpdateIdentityPoolRequest request, final AsyncHandler<UpdateIdentityPoolRequest, UpdateIdentityPoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateIdentityPoolResult>(){

            @Override
            public UpdateIdentityPoolResult call() throws Exception {
                UpdateIdentityPoolResult result;
                try {
                    result = AmazonCognitoIdentityAsyncClient.this.updateIdentityPool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

