/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model;

import com.amazonaws.services.codepipeline.model.ActionTypeId;
import com.amazonaws.services.codepipeline.model.InputArtifact;
import com.amazonaws.services.codepipeline.model.OutputArtifact;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionDeclaration
implements Serializable,
Cloneable {
    private String name;
    private ActionTypeId actionTypeId;
    private Integer runOrder;
    private Map<String, String> configuration;
    private List<OutputArtifact> outputArtifacts;
    private List<InputArtifact> inputArtifacts;
    private String roleArn;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ActionDeclaration withName(String name) {
        this.setName(name);
        return this;
    }

    public void setActionTypeId(ActionTypeId actionTypeId) {
        this.actionTypeId = actionTypeId;
    }

    public ActionTypeId getActionTypeId() {
        return this.actionTypeId;
    }

    public ActionDeclaration withActionTypeId(ActionTypeId actionTypeId) {
        this.setActionTypeId(actionTypeId);
        return this;
    }

    public void setRunOrder(Integer runOrder) {
        this.runOrder = runOrder;
    }

    public Integer getRunOrder() {
        return this.runOrder;
    }

    public ActionDeclaration withRunOrder(Integer runOrder) {
        this.setRunOrder(runOrder);
        return this;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public ActionDeclaration withConfiguration(Map<String, String> configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public ActionDeclaration addConfigurationEntry(String key, String value) {
        if (null == this.configuration) {
            this.configuration = new HashMap<String, String>();
        }
        if (this.configuration.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.configuration.put(key, value);
        return this;
    }

    public ActionDeclaration clearConfigurationEntries() {
        this.configuration = null;
        return this;
    }

    public List<OutputArtifact> getOutputArtifacts() {
        return this.outputArtifacts;
    }

    public void setOutputArtifacts(Collection<OutputArtifact> outputArtifacts) {
        if (outputArtifacts == null) {
            this.outputArtifacts = null;
            return;
        }
        this.outputArtifacts = new ArrayList<OutputArtifact>(outputArtifacts);
    }

    public ActionDeclaration withOutputArtifacts(OutputArtifact ... outputArtifacts) {
        if (this.outputArtifacts == null) {
            this.setOutputArtifacts(new ArrayList<OutputArtifact>(outputArtifacts.length));
        }
        for (OutputArtifact ele : outputArtifacts) {
            this.outputArtifacts.add(ele);
        }
        return this;
    }

    public ActionDeclaration withOutputArtifacts(Collection<OutputArtifact> outputArtifacts) {
        this.setOutputArtifacts(outputArtifacts);
        return this;
    }

    public List<InputArtifact> getInputArtifacts() {
        return this.inputArtifacts;
    }

    public void setInputArtifacts(Collection<InputArtifact> inputArtifacts) {
        if (inputArtifacts == null) {
            this.inputArtifacts = null;
            return;
        }
        this.inputArtifacts = new ArrayList<InputArtifact>(inputArtifacts);
    }

    public ActionDeclaration withInputArtifacts(InputArtifact ... inputArtifacts) {
        if (this.inputArtifacts == null) {
            this.setInputArtifacts(new ArrayList<InputArtifact>(inputArtifacts.length));
        }
        for (InputArtifact ele : inputArtifacts) {
            this.inputArtifacts.add(ele);
        }
        return this;
    }

    public ActionDeclaration withInputArtifacts(Collection<InputArtifact> inputArtifacts) {
        this.setInputArtifacts(inputArtifacts);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public ActionDeclaration withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: " + this.getName() + ",");
        }
        if (this.getActionTypeId() != null) {
            sb.append("ActionTypeId: " + this.getActionTypeId() + ",");
        }
        if (this.getRunOrder() != null) {
            sb.append("RunOrder: " + this.getRunOrder() + ",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: " + this.getConfiguration() + ",");
        }
        if (this.getOutputArtifacts() != null) {
            sb.append("OutputArtifacts: " + this.getOutputArtifacts() + ",");
        }
        if (this.getInputArtifacts() != null) {
            sb.append("InputArtifacts: " + this.getInputArtifacts() + ",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: " + this.getRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionDeclaration)) {
            return false;
        }
        ActionDeclaration other = (ActionDeclaration)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getActionTypeId() == null ^ this.getActionTypeId() == null) {
            return false;
        }
        if (other.getActionTypeId() != null && !other.getActionTypeId().equals(this.getActionTypeId())) {
            return false;
        }
        if (other.getRunOrder() == null ^ this.getRunOrder() == null) {
            return false;
        }
        if (other.getRunOrder() != null && !other.getRunOrder().equals(this.getRunOrder())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getOutputArtifacts() == null ^ this.getOutputArtifacts() == null) {
            return false;
        }
        if (other.getOutputArtifacts() != null && !other.getOutputArtifacts().equals(this.getOutputArtifacts())) {
            return false;
        }
        if (other.getInputArtifacts() == null ^ this.getInputArtifacts() == null) {
            return false;
        }
        if (other.getInputArtifacts() != null && !other.getInputArtifacts().equals(this.getInputArtifacts())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        return other.getRoleArn() == null || other.getRoleArn().equals(this.getRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getActionTypeId() == null ? 0 : this.getActionTypeId().hashCode());
        hashCode = 31 * hashCode + (this.getRunOrder() == null ? 0 : this.getRunOrder().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getOutputArtifacts() == null ? 0 : this.getOutputArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getInputArtifacts() == null ? 0 : this.getInputArtifacts().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        return hashCode;
    }

    public ActionDeclaration clone() {
        try {
            return (ActionDeclaration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

