/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CurrencyCodeValues;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.PurchaseHostReservationRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class PurchaseHostReservationRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<PurchaseHostReservationRequest> {
    private String clientToken;
    private String currencyCode;
    private SdkInternalList<String> hostIdSet;
    private String limitPrice;
    private String offeringId;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public PurchaseHostReservationRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public PurchaseHostReservationRequest withCurrencyCode(String currencyCode) {
        this.setCurrencyCode(currencyCode);
        return this;
    }

    public void setCurrencyCode(CurrencyCodeValues currencyCode) {
        this.currencyCode = currencyCode.toString();
    }

    public PurchaseHostReservationRequest withCurrencyCode(CurrencyCodeValues currencyCode) {
        this.setCurrencyCode(currencyCode);
        return this;
    }

    public List<String> getHostIdSet() {
        if (this.hostIdSet == null) {
            this.hostIdSet = new SdkInternalList();
        }
        return this.hostIdSet;
    }

    public void setHostIdSet(Collection<String> hostIdSet) {
        if (hostIdSet == null) {
            this.hostIdSet = null;
            return;
        }
        this.hostIdSet = new SdkInternalList<String>(hostIdSet);
    }

    public PurchaseHostReservationRequest withHostIdSet(String ... hostIdSet) {
        if (this.hostIdSet == null) {
            this.setHostIdSet(new SdkInternalList<String>(hostIdSet.length));
        }
        for (String ele : hostIdSet) {
            this.hostIdSet.add(ele);
        }
        return this;
    }

    public PurchaseHostReservationRequest withHostIdSet(Collection<String> hostIdSet) {
        this.setHostIdSet(hostIdSet);
        return this;
    }

    public void setLimitPrice(String limitPrice) {
        this.limitPrice = limitPrice;
    }

    public String getLimitPrice() {
        return this.limitPrice;
    }

    public PurchaseHostReservationRequest withLimitPrice(String limitPrice) {
        this.setLimitPrice(limitPrice);
        return this;
    }

    public void setOfferingId(String offeringId) {
        this.offeringId = offeringId;
    }

    public String getOfferingId() {
        return this.offeringId;
    }

    public PurchaseHostReservationRequest withOfferingId(String offeringId) {
        this.setOfferingId(offeringId);
        return this;
    }

    @Override
    public Request<PurchaseHostReservationRequest> getDryRunRequest() {
        Request<PurchaseHostReservationRequest> request = new PurchaseHostReservationRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getCurrencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.getCurrencyCode()).append(",");
        }
        if (this.getHostIdSet() != null) {
            sb.append("HostIdSet: ").append(this.getHostIdSet()).append(",");
        }
        if (this.getLimitPrice() != null) {
            sb.append("LimitPrice: ").append(this.getLimitPrice()).append(",");
        }
        if (this.getOfferingId() != null) {
            sb.append("OfferingId: ").append(this.getOfferingId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseHostReservationRequest)) {
            return false;
        }
        PurchaseHostReservationRequest other = (PurchaseHostReservationRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getCurrencyCode() == null ^ this.getCurrencyCode() == null) {
            return false;
        }
        if (other.getCurrencyCode() != null && !other.getCurrencyCode().equals(this.getCurrencyCode())) {
            return false;
        }
        if (other.getHostIdSet() == null ^ this.getHostIdSet() == null) {
            return false;
        }
        if (other.getHostIdSet() != null && !other.getHostIdSet().equals(this.getHostIdSet())) {
            return false;
        }
        if (other.getLimitPrice() == null ^ this.getLimitPrice() == null) {
            return false;
        }
        if (other.getLimitPrice() != null && !other.getLimitPrice().equals(this.getLimitPrice())) {
            return false;
        }
        if (other.getOfferingId() == null ^ this.getOfferingId() == null) {
            return false;
        }
        return other.getOfferingId() == null || other.getOfferingId().equals(this.getOfferingId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getCurrencyCode() == null ? 0 : this.getCurrencyCode().hashCode());
        hashCode = 31 * hashCode + (this.getHostIdSet() == null ? 0 : this.getHostIdSet().hashCode());
        hashCode = 31 * hashCode + (this.getLimitPrice() == null ? 0 : this.getLimitPrice().hashCode());
        hashCode = 31 * hashCode + (this.getOfferingId() == null ? 0 : this.getOfferingId().hashCode());
        return hashCode;
    }

    @Override
    public PurchaseHostReservationRequest clone() {
        return (PurchaseHostReservationRequest)super.clone();
    }
}

