/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class FilterLogEventsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String logGroupName;
    private SdkInternalList<String> logStreamNames;
    private Long startTime;
    private Long endTime;
    private String filterPattern;
    private String nextToken;
    private Integer limit;
    private Boolean interleaved;

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public FilterLogEventsRequest withLogGroupName(String logGroupName) {
        this.setLogGroupName(logGroupName);
        return this;
    }

    public List<String> getLogStreamNames() {
        if (this.logStreamNames == null) {
            this.logStreamNames = new SdkInternalList();
        }
        return this.logStreamNames;
    }

    public void setLogStreamNames(Collection<String> logStreamNames) {
        if (logStreamNames == null) {
            this.logStreamNames = null;
            return;
        }
        this.logStreamNames = new SdkInternalList<String>(logStreamNames);
    }

    public FilterLogEventsRequest withLogStreamNames(String ... logStreamNames) {
        if (this.logStreamNames == null) {
            this.setLogStreamNames(new SdkInternalList<String>(logStreamNames.length));
        }
        for (String ele : logStreamNames) {
            this.logStreamNames.add(ele);
        }
        return this;
    }

    public FilterLogEventsRequest withLogStreamNames(Collection<String> logStreamNames) {
        this.setLogStreamNames(logStreamNames);
        return this;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public FilterLogEventsRequest withStartTime(Long startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public FilterLogEventsRequest withEndTime(Long endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    public String getFilterPattern() {
        return this.filterPattern;
    }

    public FilterLogEventsRequest withFilterPattern(String filterPattern) {
        this.setFilterPattern(filterPattern);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public FilterLogEventsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public FilterLogEventsRequest withLimit(Integer limit) {
        this.setLimit(limit);
        return this;
    }

    public void setInterleaved(Boolean interleaved) {
        this.interleaved = interleaved;
    }

    public Boolean getInterleaved() {
        return this.interleaved;
    }

    public FilterLogEventsRequest withInterleaved(Boolean interleaved) {
        this.setInterleaved(interleaved);
        return this;
    }

    public Boolean isInterleaved() {
        return this.interleaved;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLogGroupName() != null) {
            sb.append("LogGroupName: ").append(this.getLogGroupName()).append(",");
        }
        if (this.getLogStreamNames() != null) {
            sb.append("LogStreamNames: ").append(this.getLogStreamNames()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getFilterPattern() != null) {
            sb.append("FilterPattern: ").append(this.getFilterPattern()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: ").append(this.getLimit()).append(",");
        }
        if (this.getInterleaved() != null) {
            sb.append("Interleaved: ").append(this.getInterleaved());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterLogEventsRequest)) {
            return false;
        }
        FilterLogEventsRequest other = (FilterLogEventsRequest)obj;
        if (other.getLogGroupName() == null ^ this.getLogGroupName() == null) {
            return false;
        }
        if (other.getLogGroupName() != null && !other.getLogGroupName().equals(this.getLogGroupName())) {
            return false;
        }
        if (other.getLogStreamNames() == null ^ this.getLogStreamNames() == null) {
            return false;
        }
        if (other.getLogStreamNames() != null && !other.getLogStreamNames().equals(this.getLogStreamNames())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getFilterPattern() == null ^ this.getFilterPattern() == null) {
            return false;
        }
        if (other.getFilterPattern() != null && !other.getFilterPattern().equals(this.getFilterPattern())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.getInterleaved() == null ^ this.getInterleaved() == null) {
            return false;
        }
        return other.getInterleaved() == null || other.getInterleaved().equals(this.getInterleaved());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLogGroupName() == null ? 0 : this.getLogGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getLogStreamNames() == null ? 0 : this.getLogStreamNames().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getFilterPattern() == null ? 0 : this.getFilterPattern().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.getInterleaved() == null ? 0 : this.getInterleaved().hashCode());
        return hashCode;
    }

    @Override
    public FilterLogEventsRequest clone() {
        return (FilterLogEventsRequest)super.clone();
    }
}

