/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.certificatemanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.certificatemanager.model.DomainValidationOption;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RequestCertificateRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String domainName;
    private List<String> subjectAlternativeNames;
    private String idempotencyToken;
    private List<DomainValidationOption> domainValidationOptions;

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public RequestCertificateRequest withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public List<String> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public void setSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
        if (subjectAlternativeNames == null) {
            this.subjectAlternativeNames = null;
            return;
        }
        this.subjectAlternativeNames = new ArrayList<String>(subjectAlternativeNames);
    }

    public RequestCertificateRequest withSubjectAlternativeNames(String ... subjectAlternativeNames) {
        if (this.subjectAlternativeNames == null) {
            this.setSubjectAlternativeNames(new ArrayList<String>(subjectAlternativeNames.length));
        }
        for (String ele : subjectAlternativeNames) {
            this.subjectAlternativeNames.add(ele);
        }
        return this;
    }

    public RequestCertificateRequest withSubjectAlternativeNames(Collection<String> subjectAlternativeNames) {
        this.setSubjectAlternativeNames(subjectAlternativeNames);
        return this;
    }

    public void setIdempotencyToken(String idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public String getIdempotencyToken() {
        return this.idempotencyToken;
    }

    public RequestCertificateRequest withIdempotencyToken(String idempotencyToken) {
        this.setIdempotencyToken(idempotencyToken);
        return this;
    }

    public List<DomainValidationOption> getDomainValidationOptions() {
        return this.domainValidationOptions;
    }

    public void setDomainValidationOptions(Collection<DomainValidationOption> domainValidationOptions) {
        if (domainValidationOptions == null) {
            this.domainValidationOptions = null;
            return;
        }
        this.domainValidationOptions = new ArrayList<DomainValidationOption>(domainValidationOptions);
    }

    public RequestCertificateRequest withDomainValidationOptions(DomainValidationOption ... domainValidationOptions) {
        if (this.domainValidationOptions == null) {
            this.setDomainValidationOptions(new ArrayList<DomainValidationOption>(domainValidationOptions.length));
        }
        for (DomainValidationOption ele : domainValidationOptions) {
            this.domainValidationOptions.add(ele);
        }
        return this;
    }

    public RequestCertificateRequest withDomainValidationOptions(Collection<DomainValidationOption> domainValidationOptions) {
        this.setDomainValidationOptions(domainValidationOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getSubjectAlternativeNames() != null) {
            sb.append("SubjectAlternativeNames: ").append(this.getSubjectAlternativeNames()).append(",");
        }
        if (this.getIdempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.getIdempotencyToken()).append(",");
        }
        if (this.getDomainValidationOptions() != null) {
            sb.append("DomainValidationOptions: ").append(this.getDomainValidationOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestCertificateRequest)) {
            return false;
        }
        RequestCertificateRequest other = (RequestCertificateRequest)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getSubjectAlternativeNames() == null ^ this.getSubjectAlternativeNames() == null) {
            return false;
        }
        if (other.getSubjectAlternativeNames() != null && !other.getSubjectAlternativeNames().equals(this.getSubjectAlternativeNames())) {
            return false;
        }
        if (other.getIdempotencyToken() == null ^ this.getIdempotencyToken() == null) {
            return false;
        }
        if (other.getIdempotencyToken() != null && !other.getIdempotencyToken().equals(this.getIdempotencyToken())) {
            return false;
        }
        if (other.getDomainValidationOptions() == null ^ this.getDomainValidationOptions() == null) {
            return false;
        }
        return other.getDomainValidationOptions() == null || other.getDomainValidationOptions().equals(this.getDomainValidationOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getSubjectAlternativeNames() == null ? 0 : this.getSubjectAlternativeNames().hashCode());
        hashCode = 31 * hashCode + (this.getIdempotencyToken() == null ? 0 : this.getIdempotencyToken().hashCode());
        hashCode = 31 * hashCode + (this.getDomainValidationOptions() == null ? 0 : this.getDomainValidationOptions().hashCode());
        return hashCode;
    }

    @Override
    public RequestCertificateRequest clone() {
        return (RequestCertificateRequest)super.clone();
    }
}

