/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.TraceSummary;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class TraceSummaryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").build();
    private static final MarshallingInfo<Double> DURATION_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").build();
    private static final MarshallingInfo<Double> RESPONSETIME_BINDING = MarshallingInfo.builder(MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseTime").build();
    private static final MarshallingInfo<Boolean> HASFAULT_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasFault").build();
    private static final MarshallingInfo<Boolean> HASERROR_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasError").build();
    private static final MarshallingInfo<Boolean> HASTHROTTLE_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasThrottle").build();
    private static final MarshallingInfo<Boolean> ISPARTIAL_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsPartial").build();
    private static final MarshallingInfo<StructuredPojo> HTTP_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Http").build();
    private static final MarshallingInfo<Map> ANNOTATIONS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Annotations").build();
    private static final MarshallingInfo<List> USERS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Users").build();
    private static final MarshallingInfo<List> SERVICEIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceIds").build();
    private static final TraceSummaryMarshaller instance = new TraceSummaryMarshaller();

    public static TraceSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(TraceSummary traceSummary, ProtocolMarshaller protocolMarshaller) {
        if (traceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(traceSummary.getId(), ID_BINDING);
            protocolMarshaller.marshall(traceSummary.getDuration(), DURATION_BINDING);
            protocolMarshaller.marshall(traceSummary.getResponseTime(), RESPONSETIME_BINDING);
            protocolMarshaller.marshall(traceSummary.getHasFault(), HASFAULT_BINDING);
            protocolMarshaller.marshall(traceSummary.getHasError(), HASERROR_BINDING);
            protocolMarshaller.marshall(traceSummary.getHasThrottle(), HASTHROTTLE_BINDING);
            protocolMarshaller.marshall(traceSummary.getIsPartial(), ISPARTIAL_BINDING);
            protocolMarshaller.marshall(traceSummary.getHttp(), HTTP_BINDING);
            protocolMarshaller.marshall(traceSummary.getAnnotations(), ANNOTATIONS_BINDING);
            protocolMarshaller.marshall(traceSummary.getUsers(), USERS_BINDING);
            protocolMarshaller.marshall(traceSummary.getServiceIds(), SERVICEIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

