/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.athena.model.EncryptionOption;
import com.amazonaws.services.athena.model.transform.EncryptionConfigurationMarshaller;
import java.io.Serializable;

public class EncryptionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String encryptionOption;
    private String kmsKey;

    public void setEncryptionOption(String encryptionOption) {
        this.encryptionOption = encryptionOption;
    }

    public String getEncryptionOption() {
        return this.encryptionOption;
    }

    public EncryptionConfiguration withEncryptionOption(String encryptionOption) {
        this.setEncryptionOption(encryptionOption);
        return this;
    }

    public void setEncryptionOption(EncryptionOption encryptionOption) {
        this.encryptionOption = encryptionOption.toString();
    }

    public EncryptionConfiguration withEncryptionOption(EncryptionOption encryptionOption) {
        this.setEncryptionOption(encryptionOption);
        return this;
    }

    public void setKmsKey(String kmsKey) {
        this.kmsKey = kmsKey;
    }

    public String getKmsKey() {
        return this.kmsKey;
    }

    public EncryptionConfiguration withKmsKey(String kmsKey) {
        this.setKmsKey(kmsKey);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEncryptionOption() != null) {
            sb.append("EncryptionOption: ").append(this.getEncryptionOption()).append(",");
        }
        if (this.getKmsKey() != null) {
            sb.append("KmsKey: ").append(this.getKmsKey());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration)obj;
        if (other.getEncryptionOption() == null ^ this.getEncryptionOption() == null) {
            return false;
        }
        if (other.getEncryptionOption() != null && !other.getEncryptionOption().equals(this.getEncryptionOption())) {
            return false;
        }
        if (other.getKmsKey() == null ^ this.getKmsKey() == null) {
            return false;
        }
        return other.getKmsKey() == null || other.getKmsKey().equals(this.getKmsKey());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEncryptionOption() == null ? 0 : this.getEncryptionOption().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKey() == null ? 0 : this.getKmsKey().hashCode());
        return hashCode;
    }

    public EncryptionConfiguration clone() {
        try {
            return (EncryptionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EncryptionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

