/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.CommandFilter;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListCommandInvocationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String commandId;
    private String instanceId;
    private Integer maxResults;
    private String nextToken;
    private SdkInternalList<CommandFilter> filters;
    private Boolean details;

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public ListCommandInvocationsRequest withCommandId(String commandId) {
        this.setCommandId(commandId);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ListCommandInvocationsRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListCommandInvocationsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCommandInvocationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<CommandFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<CommandFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList<CommandFilter>(filters);
    }

    public ListCommandInvocationsRequest withFilters(CommandFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new SdkInternalList<CommandFilter>(filters.length));
        }
        for (CommandFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public ListCommandInvocationsRequest withFilters(Collection<CommandFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setDetails(Boolean details) {
        this.details = details;
    }

    public Boolean getDetails() {
        return this.details;
    }

    public ListCommandInvocationsRequest withDetails(Boolean details) {
        this.setDetails(details);
        return this;
    }

    public Boolean isDetails() {
        return this.details;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCommandId() != null) {
            sb.append("CommandId: " + this.getCommandId() + ",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: " + this.getInstanceId() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters() + ",");
        }
        if (this.getDetails() != null) {
            sb.append("Details: " + this.getDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommandInvocationsRequest)) {
            return false;
        }
        ListCommandInvocationsRequest other = (ListCommandInvocationsRequest)obj;
        if (other.getCommandId() == null ^ this.getCommandId() == null) {
            return false;
        }
        if (other.getCommandId() != null && !other.getCommandId().equals(this.getCommandId())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getDetails() == null ^ this.getDetails() == null) {
            return false;
        }
        return other.getDetails() == null || other.getDetails().equals(this.getDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCommandId() == null ? 0 : this.getCommandId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getDetails() == null ? 0 : this.getDetails().hashCode());
        return hashCode;
    }

    @Override
    public ListCommandInvocationsRequest clone() {
        return (ListCommandInvocationsRequest)super.clone();
    }
}

