/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.databasemigrationservice.model.Connection;

public class ConnectionJsonMarshaller {
    private static ConnectionJsonMarshaller instance;

    public void marshall(Connection connection, StructuredJsonGenerator jsonGenerator) {
        if (connection == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (connection.getReplicationInstanceArn() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceArn").writeValue(connection.getReplicationInstanceArn());
            }
            if (connection.getEndpointArn() != null) {
                jsonGenerator.writeFieldName("EndpointArn").writeValue(connection.getEndpointArn());
            }
            if (connection.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(connection.getStatus());
            }
            if (connection.getLastFailureMessage() != null) {
                jsonGenerator.writeFieldName("LastFailureMessage").writeValue(connection.getLastFailureMessage());
            }
            if (connection.getEndpointIdentifier() != null) {
                jsonGenerator.writeFieldName("EndpointIdentifier").writeValue(connection.getEndpointIdentifier());
            }
            if (connection.getReplicationInstanceIdentifier() != null) {
                jsonGenerator.writeFieldName("ReplicationInstanceIdentifier").writeValue(connection.getReplicationInstanceIdentifier());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConnectionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConnectionJsonMarshaller();
        }
        return instance;
    }
}

