/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codepipeline.AWSCodePipelineAsync;
import com.amazonaws.services.codepipeline.AWSCodePipelineClient;
import com.amazonaws.services.codepipeline.model.AcknowledgeJobRequest;
import com.amazonaws.services.codepipeline.model.AcknowledgeJobResult;
import com.amazonaws.services.codepipeline.model.AcknowledgeThirdPartyJobRequest;
import com.amazonaws.services.codepipeline.model.AcknowledgeThirdPartyJobResult;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.CreateCustomActionTypeResult;
import com.amazonaws.services.codepipeline.model.CreatePipelineRequest;
import com.amazonaws.services.codepipeline.model.CreatePipelineResult;
import com.amazonaws.services.codepipeline.model.DeleteCustomActionTypeRequest;
import com.amazonaws.services.codepipeline.model.DeleteCustomActionTypeResult;
import com.amazonaws.services.codepipeline.model.DeletePipelineRequest;
import com.amazonaws.services.codepipeline.model.DeletePipelineResult;
import com.amazonaws.services.codepipeline.model.DisableStageTransitionRequest;
import com.amazonaws.services.codepipeline.model.DisableStageTransitionResult;
import com.amazonaws.services.codepipeline.model.EnableStageTransitionRequest;
import com.amazonaws.services.codepipeline.model.EnableStageTransitionResult;
import com.amazonaws.services.codepipeline.model.GetJobDetailsRequest;
import com.amazonaws.services.codepipeline.model.GetJobDetailsResult;
import com.amazonaws.services.codepipeline.model.GetPipelineRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineResult;
import com.amazonaws.services.codepipeline.model.GetPipelineStateRequest;
import com.amazonaws.services.codepipeline.model.GetPipelineStateResult;
import com.amazonaws.services.codepipeline.model.GetThirdPartyJobDetailsRequest;
import com.amazonaws.services.codepipeline.model.GetThirdPartyJobDetailsResult;
import com.amazonaws.services.codepipeline.model.ListActionTypesRequest;
import com.amazonaws.services.codepipeline.model.ListActionTypesResult;
import com.amazonaws.services.codepipeline.model.ListPipelinesRequest;
import com.amazonaws.services.codepipeline.model.ListPipelinesResult;
import com.amazonaws.services.codepipeline.model.PollForJobsRequest;
import com.amazonaws.services.codepipeline.model.PollForJobsResult;
import com.amazonaws.services.codepipeline.model.PollForThirdPartyJobsRequest;
import com.amazonaws.services.codepipeline.model.PollForThirdPartyJobsResult;
import com.amazonaws.services.codepipeline.model.PutActionRevisionRequest;
import com.amazonaws.services.codepipeline.model.PutActionRevisionResult;
import com.amazonaws.services.codepipeline.model.PutApprovalResultRequest;
import com.amazonaws.services.codepipeline.model.PutApprovalResultResult;
import com.amazonaws.services.codepipeline.model.PutJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.PutJobFailureResultResult;
import com.amazonaws.services.codepipeline.model.PutJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.PutJobSuccessResultResult;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobFailureResultRequest;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobFailureResultResult;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest;
import com.amazonaws.services.codepipeline.model.PutThirdPartyJobSuccessResultResult;
import com.amazonaws.services.codepipeline.model.RetryStageExecutionRequest;
import com.amazonaws.services.codepipeline.model.RetryStageExecutionResult;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionRequest;
import com.amazonaws.services.codepipeline.model.StartPipelineExecutionResult;
import com.amazonaws.services.codepipeline.model.UpdatePipelineRequest;
import com.amazonaws.services.codepipeline.model.UpdatePipelineResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCodePipelineAsyncClient
extends AWSCodePipelineClient
implements AWSCodePipelineAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSCodePipelineAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSCodePipelineAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSCodePipelineAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSCodePipelineAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcknowledgeJobResult> acknowledgeJobAsync(AcknowledgeJobRequest request) {
        return this.acknowledgeJobAsync(request, null);
    }

    @Override
    public Future<AcknowledgeJobResult> acknowledgeJobAsync(final AcknowledgeJobRequest request, final AsyncHandler<AcknowledgeJobRequest, AcknowledgeJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<AcknowledgeJobResult>(){

            @Override
            public AcknowledgeJobResult call() throws Exception {
                AcknowledgeJobResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.acknowledgeJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AcknowledgeThirdPartyJobResult> acknowledgeThirdPartyJobAsync(AcknowledgeThirdPartyJobRequest request) {
        return this.acknowledgeThirdPartyJobAsync(request, null);
    }

    @Override
    public Future<AcknowledgeThirdPartyJobResult> acknowledgeThirdPartyJobAsync(final AcknowledgeThirdPartyJobRequest request, final AsyncHandler<AcknowledgeThirdPartyJobRequest, AcknowledgeThirdPartyJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<AcknowledgeThirdPartyJobResult>(){

            @Override
            public AcknowledgeThirdPartyJobResult call() throws Exception {
                AcknowledgeThirdPartyJobResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.acknowledgeThirdPartyJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateCustomActionTypeResult> createCustomActionTypeAsync(CreateCustomActionTypeRequest request) {
        return this.createCustomActionTypeAsync(request, null);
    }

    @Override
    public Future<CreateCustomActionTypeResult> createCustomActionTypeAsync(final CreateCustomActionTypeRequest request, final AsyncHandler<CreateCustomActionTypeRequest, CreateCustomActionTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateCustomActionTypeResult>(){

            @Override
            public CreateCustomActionTypeResult call() throws Exception {
                CreateCustomActionTypeResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.createCustomActionType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(CreatePipelineRequest request) {
        return this.createPipelineAsync(request, null);
    }

    @Override
    public Future<CreatePipelineResult> createPipelineAsync(final CreatePipelineRequest request, final AsyncHandler<CreatePipelineRequest, CreatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePipelineResult>(){

            @Override
            public CreatePipelineResult call() throws Exception {
                CreatePipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.createPipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteCustomActionTypeResult> deleteCustomActionTypeAsync(DeleteCustomActionTypeRequest request) {
        return this.deleteCustomActionTypeAsync(request, null);
    }

    @Override
    public Future<DeleteCustomActionTypeResult> deleteCustomActionTypeAsync(final DeleteCustomActionTypeRequest request, final AsyncHandler<DeleteCustomActionTypeRequest, DeleteCustomActionTypeResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteCustomActionTypeResult>(){

            @Override
            public DeleteCustomActionTypeResult call() throws Exception {
                DeleteCustomActionTypeResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.deleteCustomActionType(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(DeletePipelineRequest request) {
        return this.deletePipelineAsync(request, null);
    }

    @Override
    public Future<DeletePipelineResult> deletePipelineAsync(final DeletePipelineRequest request, final AsyncHandler<DeletePipelineRequest, DeletePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeletePipelineResult>(){

            @Override
            public DeletePipelineResult call() throws Exception {
                DeletePipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.deletePipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableStageTransitionResult> disableStageTransitionAsync(DisableStageTransitionRequest request) {
        return this.disableStageTransitionAsync(request, null);
    }

    @Override
    public Future<DisableStageTransitionResult> disableStageTransitionAsync(final DisableStageTransitionRequest request, final AsyncHandler<DisableStageTransitionRequest, DisableStageTransitionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DisableStageTransitionResult>(){

            @Override
            public DisableStageTransitionResult call() throws Exception {
                DisableStageTransitionResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.disableStageTransition(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableStageTransitionResult> enableStageTransitionAsync(EnableStageTransitionRequest request) {
        return this.enableStageTransitionAsync(request, null);
    }

    @Override
    public Future<EnableStageTransitionResult> enableStageTransitionAsync(final EnableStageTransitionRequest request, final AsyncHandler<EnableStageTransitionRequest, EnableStageTransitionResult> asyncHandler) {
        return this.executorService.submit(new Callable<EnableStageTransitionResult>(){

            @Override
            public EnableStageTransitionResult call() throws Exception {
                EnableStageTransitionResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.enableStageTransition(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobDetailsResult> getJobDetailsAsync(GetJobDetailsRequest request) {
        return this.getJobDetailsAsync(request, null);
    }

    @Override
    public Future<GetJobDetailsResult> getJobDetailsAsync(final GetJobDetailsRequest request, final AsyncHandler<GetJobDetailsRequest, GetJobDetailsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetJobDetailsResult>(){

            @Override
            public GetJobDetailsResult call() throws Exception {
                GetJobDetailsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getJobDetails(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineResult> getPipelineAsync(GetPipelineRequest request) {
        return this.getPipelineAsync(request, null);
    }

    @Override
    public Future<GetPipelineResult> getPipelineAsync(final GetPipelineRequest request, final AsyncHandler<GetPipelineRequest, GetPipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPipelineResult>(){

            @Override
            public GetPipelineResult call() throws Exception {
                GetPipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getPipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetPipelineStateResult> getPipelineStateAsync(GetPipelineStateRequest request) {
        return this.getPipelineStateAsync(request, null);
    }

    @Override
    public Future<GetPipelineStateResult> getPipelineStateAsync(final GetPipelineStateRequest request, final AsyncHandler<GetPipelineStateRequest, GetPipelineStateResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetPipelineStateResult>(){

            @Override
            public GetPipelineStateResult call() throws Exception {
                GetPipelineStateResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getPipelineState(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetThirdPartyJobDetailsResult> getThirdPartyJobDetailsAsync(GetThirdPartyJobDetailsRequest request) {
        return this.getThirdPartyJobDetailsAsync(request, null);
    }

    @Override
    public Future<GetThirdPartyJobDetailsResult> getThirdPartyJobDetailsAsync(final GetThirdPartyJobDetailsRequest request, final AsyncHandler<GetThirdPartyJobDetailsRequest, GetThirdPartyJobDetailsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetThirdPartyJobDetailsResult>(){

            @Override
            public GetThirdPartyJobDetailsResult call() throws Exception {
                GetThirdPartyJobDetailsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.getThirdPartyJobDetails(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListActionTypesResult> listActionTypesAsync(ListActionTypesRequest request) {
        return this.listActionTypesAsync(request, null);
    }

    @Override
    public Future<ListActionTypesResult> listActionTypesAsync(final ListActionTypesRequest request, final AsyncHandler<ListActionTypesRequest, ListActionTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListActionTypesResult>(){

            @Override
            public ListActionTypesResult call() throws Exception {
                ListActionTypesResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.listActionTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(ListPipelinesRequest request) {
        return this.listPipelinesAsync(request, null);
    }

    @Override
    public Future<ListPipelinesResult> listPipelinesAsync(final ListPipelinesRequest request, final AsyncHandler<ListPipelinesRequest, ListPipelinesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPipelinesResult>(){

            @Override
            public ListPipelinesResult call() throws Exception {
                ListPipelinesResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.listPipelines(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PollForJobsResult> pollForJobsAsync(PollForJobsRequest request) {
        return this.pollForJobsAsync(request, null);
    }

    @Override
    public Future<PollForJobsResult> pollForJobsAsync(final PollForJobsRequest request, final AsyncHandler<PollForJobsRequest, PollForJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PollForJobsResult>(){

            @Override
            public PollForJobsResult call() throws Exception {
                PollForJobsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.pollForJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PollForThirdPartyJobsResult> pollForThirdPartyJobsAsync(PollForThirdPartyJobsRequest request) {
        return this.pollForThirdPartyJobsAsync(request, null);
    }

    @Override
    public Future<PollForThirdPartyJobsResult> pollForThirdPartyJobsAsync(final PollForThirdPartyJobsRequest request, final AsyncHandler<PollForThirdPartyJobsRequest, PollForThirdPartyJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<PollForThirdPartyJobsResult>(){

            @Override
            public PollForThirdPartyJobsResult call() throws Exception {
                PollForThirdPartyJobsResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.pollForThirdPartyJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutActionRevisionResult> putActionRevisionAsync(PutActionRevisionRequest request) {
        return this.putActionRevisionAsync(request, null);
    }

    @Override
    public Future<PutActionRevisionResult> putActionRevisionAsync(final PutActionRevisionRequest request, final AsyncHandler<PutActionRevisionRequest, PutActionRevisionResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutActionRevisionResult>(){

            @Override
            public PutActionRevisionResult call() throws Exception {
                PutActionRevisionResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.putActionRevision(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutApprovalResultResult> putApprovalResultAsync(PutApprovalResultRequest request) {
        return this.putApprovalResultAsync(request, null);
    }

    @Override
    public Future<PutApprovalResultResult> putApprovalResultAsync(final PutApprovalResultRequest request, final AsyncHandler<PutApprovalResultRequest, PutApprovalResultResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutApprovalResultResult>(){

            @Override
            public PutApprovalResultResult call() throws Exception {
                PutApprovalResultResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.putApprovalResult(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutJobFailureResultResult> putJobFailureResultAsync(PutJobFailureResultRequest request) {
        return this.putJobFailureResultAsync(request, null);
    }

    @Override
    public Future<PutJobFailureResultResult> putJobFailureResultAsync(final PutJobFailureResultRequest request, final AsyncHandler<PutJobFailureResultRequest, PutJobFailureResultResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutJobFailureResultResult>(){

            @Override
            public PutJobFailureResultResult call() throws Exception {
                PutJobFailureResultResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.putJobFailureResult(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutJobSuccessResultResult> putJobSuccessResultAsync(PutJobSuccessResultRequest request) {
        return this.putJobSuccessResultAsync(request, null);
    }

    @Override
    public Future<PutJobSuccessResultResult> putJobSuccessResultAsync(final PutJobSuccessResultRequest request, final AsyncHandler<PutJobSuccessResultRequest, PutJobSuccessResultResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutJobSuccessResultResult>(){

            @Override
            public PutJobSuccessResultResult call() throws Exception {
                PutJobSuccessResultResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.putJobSuccessResult(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutThirdPartyJobFailureResultResult> putThirdPartyJobFailureResultAsync(PutThirdPartyJobFailureResultRequest request) {
        return this.putThirdPartyJobFailureResultAsync(request, null);
    }

    @Override
    public Future<PutThirdPartyJobFailureResultResult> putThirdPartyJobFailureResultAsync(final PutThirdPartyJobFailureResultRequest request, final AsyncHandler<PutThirdPartyJobFailureResultRequest, PutThirdPartyJobFailureResultResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutThirdPartyJobFailureResultResult>(){

            @Override
            public PutThirdPartyJobFailureResultResult call() throws Exception {
                PutThirdPartyJobFailureResultResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.putThirdPartyJobFailureResult(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutThirdPartyJobSuccessResultResult> putThirdPartyJobSuccessResultAsync(PutThirdPartyJobSuccessResultRequest request) {
        return this.putThirdPartyJobSuccessResultAsync(request, null);
    }

    @Override
    public Future<PutThirdPartyJobSuccessResultResult> putThirdPartyJobSuccessResultAsync(final PutThirdPartyJobSuccessResultRequest request, final AsyncHandler<PutThirdPartyJobSuccessResultRequest, PutThirdPartyJobSuccessResultResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutThirdPartyJobSuccessResultResult>(){

            @Override
            public PutThirdPartyJobSuccessResultResult call() throws Exception {
                PutThirdPartyJobSuccessResultResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.putThirdPartyJobSuccessResult(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RetryStageExecutionResult> retryStageExecutionAsync(RetryStageExecutionRequest request) {
        return this.retryStageExecutionAsync(request, null);
    }

    @Override
    public Future<RetryStageExecutionResult> retryStageExecutionAsync(final RetryStageExecutionRequest request, final AsyncHandler<RetryStageExecutionRequest, RetryStageExecutionResult> asyncHandler) {
        return this.executorService.submit(new Callable<RetryStageExecutionResult>(){

            @Override
            public RetryStageExecutionResult call() throws Exception {
                RetryStageExecutionResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.retryStageExecution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartPipelineExecutionResult> startPipelineExecutionAsync(StartPipelineExecutionRequest request) {
        return this.startPipelineExecutionAsync(request, null);
    }

    @Override
    public Future<StartPipelineExecutionResult> startPipelineExecutionAsync(final StartPipelineExecutionRequest request, final AsyncHandler<StartPipelineExecutionRequest, StartPipelineExecutionResult> asyncHandler) {
        return this.executorService.submit(new Callable<StartPipelineExecutionResult>(){

            @Override
            public StartPipelineExecutionResult call() throws Exception {
                StartPipelineExecutionResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.startPipelineExecution(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(UpdatePipelineRequest request) {
        return this.updatePipelineAsync(request, null);
    }

    @Override
    public Future<UpdatePipelineResult> updatePipelineAsync(final UpdatePipelineRequest request, final AsyncHandler<UpdatePipelineRequest, UpdatePipelineResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdatePipelineResult>(){

            @Override
            public UpdatePipelineResult call() throws Exception {
                UpdatePipelineResult result;
                try {
                    result = AWSCodePipelineAsyncClient.this.updatePipeline(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

