/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.DeleteDistributionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;

public class DeleteDistributionRequestMarshaller
implements Marshaller<Request<DeleteDistributionRequest>, DeleteDistributionRequest> {
    @Override
    public Request<DeleteDistributionRequest> marshall(DeleteDistributionRequest deleteDistributionRequest) {
        if (deleteDistributionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteDistributionRequest> request = new DefaultRequest<DeleteDistributionRequest>(deleteDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.DELETE);
        if (deleteDistributionRequest.getIfMatch() != null) {
            request.addHeader("If-Match", StringUtils.fromString(deleteDistributionRequest.getIfMatch()));
        }
        String uriResourcePath = "/2016-01-28/distribution/{Id}";
        uriResourcePath = uriResourcePath.replace("{Id}", deleteDistributionRequest.getId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteDistributionRequest.getId()), false) : "");
        request.setResourcePath(uriResourcePath);
        return request;
    }
}

