/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.DeleteApiKeyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteApiKeyRequestMarshaller
implements Marshaller<Request<DeleteApiKeyRequest>, DeleteApiKeyRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteApiKeyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteApiKeyRequest> marshall(DeleteApiKeyRequest deleteApiKeyRequest) {
        if (deleteApiKeyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteApiKeyRequest> request = new DefaultRequest<DeleteApiKeyRequest>(deleteApiKeyRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/apikeys/{api_Key}";
        uriResourcePath = uriResourcePath.replace("{api_Key}", deleteApiKeyRequest.getApiKey() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteApiKeyRequest.getApiKey()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

