/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.http.JsonErrorCodeParser;
import com.amazonaws.internal.http.JsonErrorMessageParser;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.util.IOUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class JsonErrorResponseHandler
implements HttpResponseHandler<AmazonServiceException> {
    private static final Log LOG = LogFactory.getLog(JsonErrorResponseHandler.class);
    private final List<JsonErrorUnmarshaller> unmarshallers;
    private final JsonErrorCodeParser errorCodeParser;
    private final JsonErrorMessageParser errorMessageParser;
    private final JsonFactory jsonFactory;

    public JsonErrorResponseHandler(List<JsonErrorUnmarshaller> errorUnmarshallers, JsonErrorCodeParser errorCodeParser, JsonErrorMessageParser errorMessageParser, JsonFactory jsonFactory) {
        this.unmarshallers = errorUnmarshallers;
        this.errorCodeParser = errorCodeParser;
        this.errorMessageParser = errorMessageParser;
        this.jsonFactory = jsonFactory;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }

    @Override
    public AmazonServiceException handle(HttpResponse response) throws Exception {
        JsonContent jsonContent = JsonContent.createJsonContent(response, this.jsonFactory);
        String errorCode = this.errorCodeParser.parseErrorCode(response.getHeaders(), jsonContent.jsonNode);
        AmazonServiceException ase = this.createException(errorCode, jsonContent);
        if (ase.getErrorMessage() == null) {
            ase.setErrorMessage(this.errorMessageParser.parseErrorMessage(jsonContent.jsonNode));
        }
        ase.setErrorCode(errorCode);
        ase.setServiceName(response.getRequest().getServiceName());
        ase.setStatusCode(response.getStatusCode());
        ase.setErrorType(this.getErrorTypeFromStatusCode(response.getStatusCode()));
        ase.setRawResponse(jsonContent.rawContent);
        String requestId = this.getRequestIdFromHeaders(response.getHeaders());
        if (requestId != null) {
            ase.setRequestId(requestId);
        }
        ase.setHttpHeaders(response.getHeaders());
        return ase;
    }

    private AmazonServiceException createException(String errorCode, JsonContent jsonContent) {
        if (!jsonContent.isJsonValid()) {
            return new AmazonServiceException("Unable to parse HTTP response content");
        }
        AmazonServiceException ase = this.unmarshallException(errorCode, jsonContent);
        if (ase == null) {
            ase = new AmazonServiceException("Unable to unmarshall exception response with the unmarshallers provided");
        }
        return ase;
    }

    private AmazonServiceException unmarshallException(String errorCode, JsonContent jsonContent) {
        for (JsonErrorUnmarshaller unmarshaller : this.unmarshallers) {
            if (!unmarshaller.matchErrorCode(errorCode)) continue;
            try {
                return unmarshaller.unmarshall(jsonContent.jsonNode);
            }
            catch (Exception e) {
                LOG.info((Object)"Unable to unmarshall exception content", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private AmazonServiceException.ErrorType getErrorTypeFromStatusCode(int statusCode) {
        return statusCode < 500 ? AmazonServiceException.ErrorType.Client : AmazonServiceException.ErrorType.Service;
    }

    private String getRequestIdFromHeaders(Map<String, String> headers) {
        for (Map.Entry<String, String> headerEntry : headers.entrySet()) {
            if (!headerEntry.getKey().equalsIgnoreCase("x-amzn-RequestId")) continue;
            return headerEntry.getValue();
        }
        return null;
    }

    private static class JsonContent {
        public final byte[] rawContent;
        public final JsonNode jsonNode;
        private final ObjectMapper mapper;

        public static JsonContent createJsonContent(HttpResponse httpResponse, JsonFactory jsonFactory) {
            byte[] rawJsonContent = null;
            try {
                if (httpResponse.getContent() != null) {
                    rawJsonContent = IOUtils.toByteArray(httpResponse.getContent());
                }
            }
            catch (Exception e) {
                LOG.info((Object)"Unable to read HTTP response content", (Throwable)e);
            }
            return new JsonContent(rawJsonContent, new ObjectMapper(jsonFactory).configure(JsonParser.Feature.ALLOW_COMMENTS, true));
        }

        private JsonContent(byte[] rawJsonContent, ObjectMapper mapper) {
            this.rawContent = rawJsonContent;
            this.jsonNode = JsonContent.parseJsonContent(rawJsonContent, mapper);
            this.mapper = mapper;
        }

        private static JsonNode parseJsonContent(byte[] rawJsonContent, ObjectMapper mapper) {
            if (rawJsonContent == null) {
                return null;
            }
            try {
                return mapper.readTree(rawJsonContent);
            }
            catch (Exception e) {
                LOG.info((Object)"Unable to parse HTTP response content", (Throwable)e);
                return null;
            }
        }

        public boolean isJsonValid() {
            return this.jsonNode != null;
        }
    }
}

