/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.services.glacier.model.transform.DefaultAccountIdSupplier;
import java.io.InputStream;

@SdkInternalApi
public class UploadArchiveRequestMarshaller {
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier(DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> ARCHIVEDESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-archive-description").build();
    private static final MarshallingInfo<String> CHECKSUM_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-sha256-tree-hash").build();
    private static final MarshallingInfo<InputStream> BODY_BINDING = MarshallingInfo.builder(MarshallingType.STREAM).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(true).build();
    private static final MarshallingInfo<Long> CONTENTLENGTH_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Content-Length").build();
    private static final UploadArchiveRequestMarshaller instance = new UploadArchiveRequestMarshaller();

    public static UploadArchiveRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(UploadArchiveRequest uploadArchiveRequest, ProtocolMarshaller protocolMarshaller) {
        if (uploadArchiveRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(uploadArchiveRequest.getVaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall(uploadArchiveRequest.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(uploadArchiveRequest.getArchiveDescription(), ARCHIVEDESCRIPTION_BINDING);
            protocolMarshaller.marshall(uploadArchiveRequest.getChecksum(), CHECKSUM_BINDING);
            protocolMarshaller.marshall(uploadArchiveRequest.getBody(), BODY_BINDING);
            protocolMarshaller.marshall(uploadArchiveRequest.getContentLength(), CONTENTLENGTH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

