/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionValueType;
import com.amazonaws.services.elasticbeanstalk.model.OptionRestrictionRegex;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ConfigurationOptionDescription
implements Serializable,
Cloneable {
    private String namespace;
    private String name;
    private String defaultValue;
    private String changeSeverity;
    private Boolean userDefined;
    private String valueType;
    private SdkInternalList<String> valueOptions;
    private Integer minValue;
    private Integer maxValue;
    private Integer maxLength;
    private OptionRestrictionRegex regex;

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ConfigurationOptionDescription withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ConfigurationOptionDescription withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ConfigurationOptionDescription withDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public void setChangeSeverity(String changeSeverity) {
        this.changeSeverity = changeSeverity;
    }

    public String getChangeSeverity() {
        return this.changeSeverity;
    }

    public ConfigurationOptionDescription withChangeSeverity(String changeSeverity) {
        this.setChangeSeverity(changeSeverity);
        return this;
    }

    public void setUserDefined(Boolean userDefined) {
        this.userDefined = userDefined;
    }

    public Boolean getUserDefined() {
        return this.userDefined;
    }

    public ConfigurationOptionDescription withUserDefined(Boolean userDefined) {
        this.setUserDefined(userDefined);
        return this;
    }

    public Boolean isUserDefined() {
        return this.userDefined;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getValueType() {
        return this.valueType;
    }

    public ConfigurationOptionDescription withValueType(String valueType) {
        this.setValueType(valueType);
        return this;
    }

    public void setValueType(ConfigurationOptionValueType valueType) {
        this.valueType = valueType.toString();
    }

    public ConfigurationOptionDescription withValueType(ConfigurationOptionValueType valueType) {
        this.setValueType(valueType);
        return this;
    }

    public List<String> getValueOptions() {
        if (this.valueOptions == null) {
            this.valueOptions = new SdkInternalList();
        }
        return this.valueOptions;
    }

    public void setValueOptions(Collection<String> valueOptions) {
        if (valueOptions == null) {
            this.valueOptions = null;
            return;
        }
        this.valueOptions = new SdkInternalList<String>(valueOptions);
    }

    public ConfigurationOptionDescription withValueOptions(String ... valueOptions) {
        if (this.valueOptions == null) {
            this.setValueOptions(new SdkInternalList<String>(valueOptions.length));
        }
        for (String ele : valueOptions) {
            this.valueOptions.add(ele);
        }
        return this;
    }

    public ConfigurationOptionDescription withValueOptions(Collection<String> valueOptions) {
        this.setValueOptions(valueOptions);
        return this;
    }

    public void setMinValue(Integer minValue) {
        this.minValue = minValue;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public ConfigurationOptionDescription withMinValue(Integer minValue) {
        this.setMinValue(minValue);
        return this;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public ConfigurationOptionDescription withMaxValue(Integer maxValue) {
        this.setMaxValue(maxValue);
        return this;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public ConfigurationOptionDescription withMaxLength(Integer maxLength) {
        this.setMaxLength(maxLength);
        return this;
    }

    public void setRegex(OptionRestrictionRegex regex) {
        this.regex = regex;
    }

    public OptionRestrictionRegex getRegex() {
        return this.regex;
    }

    public ConfigurationOptionDescription withRegex(OptionRestrictionRegex regex) {
        this.setRegex(regex);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue()).append(",");
        }
        if (this.getChangeSeverity() != null) {
            sb.append("ChangeSeverity: ").append(this.getChangeSeverity()).append(",");
        }
        if (this.getUserDefined() != null) {
            sb.append("UserDefined: ").append(this.getUserDefined()).append(",");
        }
        if (this.getValueType() != null) {
            sb.append("ValueType: ").append(this.getValueType()).append(",");
        }
        if (this.getValueOptions() != null) {
            sb.append("ValueOptions: ").append(this.getValueOptions()).append(",");
        }
        if (this.getMinValue() != null) {
            sb.append("MinValue: ").append(this.getMinValue()).append(",");
        }
        if (this.getMaxValue() != null) {
            sb.append("MaxValue: ").append(this.getMaxValue()).append(",");
        }
        if (this.getMaxLength() != null) {
            sb.append("MaxLength: ").append(this.getMaxLength()).append(",");
        }
        if (this.getRegex() != null) {
            sb.append("Regex: ").append(this.getRegex());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationOptionDescription)) {
            return false;
        }
        ConfigurationOptionDescription other = (ConfigurationOptionDescription)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        if (other.getDefaultValue() != null && !other.getDefaultValue().equals(this.getDefaultValue())) {
            return false;
        }
        if (other.getChangeSeverity() == null ^ this.getChangeSeverity() == null) {
            return false;
        }
        if (other.getChangeSeverity() != null && !other.getChangeSeverity().equals(this.getChangeSeverity())) {
            return false;
        }
        if (other.getUserDefined() == null ^ this.getUserDefined() == null) {
            return false;
        }
        if (other.getUserDefined() != null && !other.getUserDefined().equals(this.getUserDefined())) {
            return false;
        }
        if (other.getValueType() == null ^ this.getValueType() == null) {
            return false;
        }
        if (other.getValueType() != null && !other.getValueType().equals(this.getValueType())) {
            return false;
        }
        if (other.getValueOptions() == null ^ this.getValueOptions() == null) {
            return false;
        }
        if (other.getValueOptions() != null && !other.getValueOptions().equals(this.getValueOptions())) {
            return false;
        }
        if (other.getMinValue() == null ^ this.getMinValue() == null) {
            return false;
        }
        if (other.getMinValue() != null && !other.getMinValue().equals(this.getMinValue())) {
            return false;
        }
        if (other.getMaxValue() == null ^ this.getMaxValue() == null) {
            return false;
        }
        if (other.getMaxValue() != null && !other.getMaxValue().equals(this.getMaxValue())) {
            return false;
        }
        if (other.getMaxLength() == null ^ this.getMaxLength() == null) {
            return false;
        }
        if (other.getMaxLength() != null && !other.getMaxLength().equals(this.getMaxLength())) {
            return false;
        }
        if (other.getRegex() == null ^ this.getRegex() == null) {
            return false;
        }
        return other.getRegex() == null || other.getRegex().equals(this.getRegex());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        hashCode = 31 * hashCode + (this.getChangeSeverity() == null ? 0 : this.getChangeSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getUserDefined() == null ? 0 : this.getUserDefined().hashCode());
        hashCode = 31 * hashCode + (this.getValueType() == null ? 0 : this.getValueType().hashCode());
        hashCode = 31 * hashCode + (this.getValueOptions() == null ? 0 : this.getValueOptions().hashCode());
        hashCode = 31 * hashCode + (this.getMinValue() == null ? 0 : this.getMinValue().hashCode());
        hashCode = 31 * hashCode + (this.getMaxValue() == null ? 0 : this.getMaxValue().hashCode());
        hashCode = 31 * hashCode + (this.getMaxLength() == null ? 0 : this.getMaxLength().hashCode());
        hashCode = 31 * hashCode + (this.getRegex() == null ? 0 : this.getRegex().hashCode());
        return hashCode;
    }

    public ConfigurationOptionDescription clone() {
        try {
            return (ConfigurationOptionDescription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

