/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.stepfunctions.AWSStepFunctionsAsync;
import com.amazonaws.services.stepfunctions.AWSStepFunctionsAsyncClientBuilder;
import com.amazonaws.services.stepfunctions.AWSStepFunctionsClient;
import com.amazonaws.services.stepfunctions.model.CreateActivityRequest;
import com.amazonaws.services.stepfunctions.model.CreateActivityResult;
import com.amazonaws.services.stepfunctions.model.CreateStateMachineRequest;
import com.amazonaws.services.stepfunctions.model.CreateStateMachineResult;
import com.amazonaws.services.stepfunctions.model.DeleteActivityRequest;
import com.amazonaws.services.stepfunctions.model.DeleteActivityResult;
import com.amazonaws.services.stepfunctions.model.DeleteStateMachineRequest;
import com.amazonaws.services.stepfunctions.model.DeleteStateMachineResult;
import com.amazonaws.services.stepfunctions.model.DescribeActivityRequest;
import com.amazonaws.services.stepfunctions.model.DescribeActivityResult;
import com.amazonaws.services.stepfunctions.model.DescribeExecutionRequest;
import com.amazonaws.services.stepfunctions.model.DescribeExecutionResult;
import com.amazonaws.services.stepfunctions.model.DescribeStateMachineRequest;
import com.amazonaws.services.stepfunctions.model.DescribeStateMachineResult;
import com.amazonaws.services.stepfunctions.model.GetActivityTaskRequest;
import com.amazonaws.services.stepfunctions.model.GetActivityTaskResult;
import com.amazonaws.services.stepfunctions.model.GetExecutionHistoryRequest;
import com.amazonaws.services.stepfunctions.model.GetExecutionHistoryResult;
import com.amazonaws.services.stepfunctions.model.ListActivitiesRequest;
import com.amazonaws.services.stepfunctions.model.ListActivitiesResult;
import com.amazonaws.services.stepfunctions.model.ListExecutionsRequest;
import com.amazonaws.services.stepfunctions.model.ListExecutionsResult;
import com.amazonaws.services.stepfunctions.model.ListStateMachinesRequest;
import com.amazonaws.services.stepfunctions.model.ListStateMachinesResult;
import com.amazonaws.services.stepfunctions.model.SendTaskFailureRequest;
import com.amazonaws.services.stepfunctions.model.SendTaskFailureResult;
import com.amazonaws.services.stepfunctions.model.SendTaskHeartbeatRequest;
import com.amazonaws.services.stepfunctions.model.SendTaskHeartbeatResult;
import com.amazonaws.services.stepfunctions.model.SendTaskSuccessRequest;
import com.amazonaws.services.stepfunctions.model.SendTaskSuccessResult;
import com.amazonaws.services.stepfunctions.model.StartExecutionRequest;
import com.amazonaws.services.stepfunctions.model.StartExecutionResult;
import com.amazonaws.services.stepfunctions.model.StopExecutionRequest;
import com.amazonaws.services.stepfunctions.model.StopExecutionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSStepFunctionsAsyncClient
extends AWSStepFunctionsClient
implements AWSStepFunctionsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSStepFunctionsAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSStepFunctionsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSStepFunctionsAsyncClientBuilder asyncBuilder() {
        return AWSStepFunctionsAsyncClientBuilder.standard();
    }

    AWSStepFunctionsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateActivityResult> createActivityAsync(CreateActivityRequest request) {
        return this.createActivityAsync(request, null);
    }

    @Override
    public Future<CreateActivityResult> createActivityAsync(CreateActivityRequest request, final AsyncHandler<CreateActivityRequest, CreateActivityResult> asyncHandler) {
        final CreateActivityRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateActivityResult>(){

            @Override
            public CreateActivityResult call() throws Exception {
                CreateActivityResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeCreateActivity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStateMachineResult> createStateMachineAsync(CreateStateMachineRequest request) {
        return this.createStateMachineAsync(request, null);
    }

    @Override
    public Future<CreateStateMachineResult> createStateMachineAsync(CreateStateMachineRequest request, final AsyncHandler<CreateStateMachineRequest, CreateStateMachineResult> asyncHandler) {
        final CreateStateMachineRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateStateMachineResult>(){

            @Override
            public CreateStateMachineResult call() throws Exception {
                CreateStateMachineResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeCreateStateMachine(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteActivityResult> deleteActivityAsync(DeleteActivityRequest request) {
        return this.deleteActivityAsync(request, null);
    }

    @Override
    public Future<DeleteActivityResult> deleteActivityAsync(DeleteActivityRequest request, final AsyncHandler<DeleteActivityRequest, DeleteActivityResult> asyncHandler) {
        final DeleteActivityRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteActivityResult>(){

            @Override
            public DeleteActivityResult call() throws Exception {
                DeleteActivityResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeDeleteActivity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStateMachineResult> deleteStateMachineAsync(DeleteStateMachineRequest request) {
        return this.deleteStateMachineAsync(request, null);
    }

    @Override
    public Future<DeleteStateMachineResult> deleteStateMachineAsync(DeleteStateMachineRequest request, final AsyncHandler<DeleteStateMachineRequest, DeleteStateMachineResult> asyncHandler) {
        final DeleteStateMachineRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteStateMachineResult>(){

            @Override
            public DeleteStateMachineResult call() throws Exception {
                DeleteStateMachineResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeDeleteStateMachine(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeActivityResult> describeActivityAsync(DescribeActivityRequest request) {
        return this.describeActivityAsync(request, null);
    }

    @Override
    public Future<DescribeActivityResult> describeActivityAsync(DescribeActivityRequest request, final AsyncHandler<DescribeActivityRequest, DescribeActivityResult> asyncHandler) {
        final DescribeActivityRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeActivityResult>(){

            @Override
            public DescribeActivityResult call() throws Exception {
                DescribeActivityResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeDescribeActivity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeExecutionResult> describeExecutionAsync(DescribeExecutionRequest request) {
        return this.describeExecutionAsync(request, null);
    }

    @Override
    public Future<DescribeExecutionResult> describeExecutionAsync(DescribeExecutionRequest request, final AsyncHandler<DescribeExecutionRequest, DescribeExecutionResult> asyncHandler) {
        final DescribeExecutionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeExecutionResult>(){

            @Override
            public DescribeExecutionResult call() throws Exception {
                DescribeExecutionResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeDescribeExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStateMachineResult> describeStateMachineAsync(DescribeStateMachineRequest request) {
        return this.describeStateMachineAsync(request, null);
    }

    @Override
    public Future<DescribeStateMachineResult> describeStateMachineAsync(DescribeStateMachineRequest request, final AsyncHandler<DescribeStateMachineRequest, DescribeStateMachineResult> asyncHandler) {
        final DescribeStateMachineRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeStateMachineResult>(){

            @Override
            public DescribeStateMachineResult call() throws Exception {
                DescribeStateMachineResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeDescribeStateMachine(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetActivityTaskResult> getActivityTaskAsync(GetActivityTaskRequest request) {
        return this.getActivityTaskAsync(request, null);
    }

    @Override
    public Future<GetActivityTaskResult> getActivityTaskAsync(GetActivityTaskRequest request, final AsyncHandler<GetActivityTaskRequest, GetActivityTaskResult> asyncHandler) {
        final GetActivityTaskRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetActivityTaskResult>(){

            @Override
            public GetActivityTaskResult call() throws Exception {
                GetActivityTaskResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeGetActivityTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetExecutionHistoryResult> getExecutionHistoryAsync(GetExecutionHistoryRequest request) {
        return this.getExecutionHistoryAsync(request, null);
    }

    @Override
    public Future<GetExecutionHistoryResult> getExecutionHistoryAsync(GetExecutionHistoryRequest request, final AsyncHandler<GetExecutionHistoryRequest, GetExecutionHistoryResult> asyncHandler) {
        final GetExecutionHistoryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetExecutionHistoryResult>(){

            @Override
            public GetExecutionHistoryResult call() throws Exception {
                GetExecutionHistoryResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeGetExecutionHistory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListActivitiesResult> listActivitiesAsync(ListActivitiesRequest request) {
        return this.listActivitiesAsync(request, null);
    }

    @Override
    public Future<ListActivitiesResult> listActivitiesAsync(ListActivitiesRequest request, final AsyncHandler<ListActivitiesRequest, ListActivitiesResult> asyncHandler) {
        final ListActivitiesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListActivitiesResult>(){

            @Override
            public ListActivitiesResult call() throws Exception {
                ListActivitiesResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeListActivities(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExecutionsResult> listExecutionsAsync(ListExecutionsRequest request) {
        return this.listExecutionsAsync(request, null);
    }

    @Override
    public Future<ListExecutionsResult> listExecutionsAsync(ListExecutionsRequest request, final AsyncHandler<ListExecutionsRequest, ListExecutionsResult> asyncHandler) {
        final ListExecutionsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExecutionsResult>(){

            @Override
            public ListExecutionsResult call() throws Exception {
                ListExecutionsResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeListExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListStateMachinesResult> listStateMachinesAsync(ListStateMachinesRequest request) {
        return this.listStateMachinesAsync(request, null);
    }

    @Override
    public Future<ListStateMachinesResult> listStateMachinesAsync(ListStateMachinesRequest request, final AsyncHandler<ListStateMachinesRequest, ListStateMachinesResult> asyncHandler) {
        final ListStateMachinesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListStateMachinesResult>(){

            @Override
            public ListStateMachinesResult call() throws Exception {
                ListStateMachinesResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeListStateMachines(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendTaskFailureResult> sendTaskFailureAsync(SendTaskFailureRequest request) {
        return this.sendTaskFailureAsync(request, null);
    }

    @Override
    public Future<SendTaskFailureResult> sendTaskFailureAsync(SendTaskFailureRequest request, final AsyncHandler<SendTaskFailureRequest, SendTaskFailureResult> asyncHandler) {
        final SendTaskFailureRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendTaskFailureResult>(){

            @Override
            public SendTaskFailureResult call() throws Exception {
                SendTaskFailureResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeSendTaskFailure(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendTaskHeartbeatResult> sendTaskHeartbeatAsync(SendTaskHeartbeatRequest request) {
        return this.sendTaskHeartbeatAsync(request, null);
    }

    @Override
    public Future<SendTaskHeartbeatResult> sendTaskHeartbeatAsync(SendTaskHeartbeatRequest request, final AsyncHandler<SendTaskHeartbeatRequest, SendTaskHeartbeatResult> asyncHandler) {
        final SendTaskHeartbeatRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendTaskHeartbeatResult>(){

            @Override
            public SendTaskHeartbeatResult call() throws Exception {
                SendTaskHeartbeatResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeSendTaskHeartbeat(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SendTaskSuccessResult> sendTaskSuccessAsync(SendTaskSuccessRequest request) {
        return this.sendTaskSuccessAsync(request, null);
    }

    @Override
    public Future<SendTaskSuccessResult> sendTaskSuccessAsync(SendTaskSuccessRequest request, final AsyncHandler<SendTaskSuccessRequest, SendTaskSuccessResult> asyncHandler) {
        final SendTaskSuccessRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<SendTaskSuccessResult>(){

            @Override
            public SendTaskSuccessResult call() throws Exception {
                SendTaskSuccessResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeSendTaskSuccess(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartExecutionResult> startExecutionAsync(StartExecutionRequest request) {
        return this.startExecutionAsync(request, null);
    }

    @Override
    public Future<StartExecutionResult> startExecutionAsync(StartExecutionRequest request, final AsyncHandler<StartExecutionRequest, StartExecutionResult> asyncHandler) {
        final StartExecutionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartExecutionResult>(){

            @Override
            public StartExecutionResult call() throws Exception {
                StartExecutionResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeStartExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopExecutionResult> stopExecutionAsync(StopExecutionRequest request) {
        return this.stopExecutionAsync(request, null);
    }

    @Override
    public Future<StopExecutionResult> stopExecutionAsync(StopExecutionRequest request, final AsyncHandler<StopExecutionRequest, StopExecutionResult> asyncHandler) {
        final StopExecutionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopExecutionResult>(){

            @Override
            public StopExecutionResult call() throws Exception {
                StopExecutionResult result = null;
                try {
                    result = AWSStepFunctionsAsyncClient.this.executeStopExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

