/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.TaggedResource;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeTagsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<TaggedResource> taggedResources;
    private String marker;

    public List<TaggedResource> getTaggedResources() {
        if (this.taggedResources == null) {
            this.taggedResources = new SdkInternalList();
        }
        return this.taggedResources;
    }

    public void setTaggedResources(Collection<TaggedResource> taggedResources) {
        if (taggedResources == null) {
            this.taggedResources = null;
            return;
        }
        this.taggedResources = new SdkInternalList<TaggedResource>(taggedResources);
    }

    public DescribeTagsResult withTaggedResources(TaggedResource ... taggedResources) {
        if (this.taggedResources == null) {
            this.setTaggedResources(new SdkInternalList<TaggedResource>(taggedResources.length));
        }
        for (TaggedResource ele : taggedResources) {
            this.taggedResources.add(ele);
        }
        return this;
    }

    public DescribeTagsResult withTaggedResources(Collection<TaggedResource> taggedResources) {
        this.setTaggedResources(taggedResources);
        return this;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeTagsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaggedResources() != null) {
            sb.append("TaggedResources: ").append(this.getTaggedResources()).append(",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResult)) {
            return false;
        }
        DescribeTagsResult other = (DescribeTagsResult)obj;
        if (other.getTaggedResources() == null ^ this.getTaggedResources() == null) {
            return false;
        }
        if (other.getTaggedResources() != null && !other.getTaggedResources().equals(this.getTaggedResources())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaggedResources() == null ? 0 : this.getTaggedResources().hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public DescribeTagsResult clone() {
        try {
            return (DescribeTagsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

