/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.clouddirectory.model.ObjectAttributeUpdate;
import com.amazonaws.services.clouddirectory.model.ObjectReference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateObjectAttributesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String directoryArn;
    private ObjectReference objectReference;
    private List<ObjectAttributeUpdate> attributeUpdates;

    public void setDirectoryArn(String directoryArn) {
        this.directoryArn = directoryArn;
    }

    public String getDirectoryArn() {
        return this.directoryArn;
    }

    public UpdateObjectAttributesRequest withDirectoryArn(String directoryArn) {
        this.setDirectoryArn(directoryArn);
        return this;
    }

    public void setObjectReference(ObjectReference objectReference) {
        this.objectReference = objectReference;
    }

    public ObjectReference getObjectReference() {
        return this.objectReference;
    }

    public UpdateObjectAttributesRequest withObjectReference(ObjectReference objectReference) {
        this.setObjectReference(objectReference);
        return this;
    }

    public List<ObjectAttributeUpdate> getAttributeUpdates() {
        return this.attributeUpdates;
    }

    public void setAttributeUpdates(Collection<ObjectAttributeUpdate> attributeUpdates) {
        if (attributeUpdates == null) {
            this.attributeUpdates = null;
            return;
        }
        this.attributeUpdates = new ArrayList<ObjectAttributeUpdate>(attributeUpdates);
    }

    public UpdateObjectAttributesRequest withAttributeUpdates(ObjectAttributeUpdate ... attributeUpdates) {
        if (this.attributeUpdates == null) {
            this.setAttributeUpdates(new ArrayList<ObjectAttributeUpdate>(attributeUpdates.length));
        }
        for (ObjectAttributeUpdate ele : attributeUpdates) {
            this.attributeUpdates.add(ele);
        }
        return this;
    }

    public UpdateObjectAttributesRequest withAttributeUpdates(Collection<ObjectAttributeUpdate> attributeUpdates) {
        this.setAttributeUpdates(attributeUpdates);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.getDirectoryArn()).append(",");
        }
        if (this.getObjectReference() != null) {
            sb.append("ObjectReference: ").append(this.getObjectReference()).append(",");
        }
        if (this.getAttributeUpdates() != null) {
            sb.append("AttributeUpdates: ").append(this.getAttributeUpdates());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateObjectAttributesRequest)) {
            return false;
        }
        UpdateObjectAttributesRequest other = (UpdateObjectAttributesRequest)obj;
        if (other.getDirectoryArn() == null ^ this.getDirectoryArn() == null) {
            return false;
        }
        if (other.getDirectoryArn() != null && !other.getDirectoryArn().equals(this.getDirectoryArn())) {
            return false;
        }
        if (other.getObjectReference() == null ^ this.getObjectReference() == null) {
            return false;
        }
        if (other.getObjectReference() != null && !other.getObjectReference().equals(this.getObjectReference())) {
            return false;
        }
        if (other.getAttributeUpdates() == null ^ this.getAttributeUpdates() == null) {
            return false;
        }
        return other.getAttributeUpdates() == null || other.getAttributeUpdates().equals(this.getAttributeUpdates());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryArn() == null ? 0 : this.getDirectoryArn().hashCode());
        hashCode = 31 * hashCode + (this.getObjectReference() == null ? 0 : this.getObjectReference().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeUpdates() == null ? 0 : this.getAttributeUpdates().hashCode());
        return hashCode;
    }

    @Override
    public UpdateObjectAttributesRequest clone() {
        return (UpdateObjectAttributesRequest)super.clone();
    }
}

