/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.S3OutputUrl;

@SdkInternalApi
public class S3OutputUrlMarshaller {
    private static final MarshallingInfo<String> OUTPUTURL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OutputUrl").build();
    private static final S3OutputUrlMarshaller instance = new S3OutputUrlMarshaller();

    public static S3OutputUrlMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3OutputUrl s3OutputUrl, ProtocolMarshaller protocolMarshaller) {
        if (s3OutputUrl == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(s3OutputUrl.getOutputUrl(), OUTPUTURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

