/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ModifyVolumeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyVolumeRequestMarshaller
implements Marshaller<Request<ModifyVolumeRequest>, ModifyVolumeRequest> {
    @Override
    public Request<ModifyVolumeRequest> marshall(ModifyVolumeRequest modifyVolumeRequest) {
        if (modifyVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyVolumeRequest> request = new DefaultRequest<ModifyVolumeRequest>(modifyVolumeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVolumeRequest.getVolumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString(modifyVolumeRequest.getVolumeId()));
        }
        if (modifyVolumeRequest.getSize() != null) {
            request.addParameter("Size", StringUtils.fromInteger(modifyVolumeRequest.getSize()));
        }
        if (modifyVolumeRequest.getVolumeType() != null) {
            request.addParameter("VolumeType", StringUtils.fromString(modifyVolumeRequest.getVolumeType()));
        }
        if (modifyVolumeRequest.getIops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger(modifyVolumeRequest.getIops()));
        }
        return request;
    }
}

