/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.document.internal;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import com.amazonaws.services.dynamodbv2.document.KeyConditions;
import com.amazonaws.services.dynamodbv2.document.QueryFilter;
import com.amazonaws.services.dynamodbv2.document.QueryOutcome;
import com.amazonaws.services.dynamodbv2.document.RangeKeyCondition;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.api.QueryApi;
import com.amazonaws.services.dynamodbv2.document.internal.AbstractImpl;
import com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import com.amazonaws.services.dynamodbv2.document.internal.QueryCollection;
import com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import java.util.Collection;
import java.util.Map;

public class QueryImpl
extends AbstractImpl
implements QueryApi {
    public QueryImpl(AmazonDynamoDB client, Table table) {
        super(client, table);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKey) {
        return this.doQuery(new QuerySpec().withHashKey(new KeyAttribute(hashKeyName, hashKey)));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey).withRangeKeyCondition(rangeKeyCondition));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey).withRangeKeyCondition(rangeKeyCondition).withQueryFilters(queryFilters));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey).withRangeKeyCondition(rangeKeyCondition).withFilterExpression(filterExpression).withNameMap(nameMap).withValueMap(valueMap));
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.doQuery(new QuerySpec().withHashKey(hashKey).withRangeKeyCondition(rangeKeyCondition).withFilterExpression(filterExpression).withProjectionExpression(projectionExpression).withNameMap(nameMap).withValueMap(valueMap));
    }

    @Override
    public ItemCollection<QueryOutcome> query(QuerySpec spec) {
        return this.doQuery(spec);
    }

    protected ItemCollection<QueryOutcome> doQuery(QuerySpec spec) {
        Collection<KeyAttribute> startKey;
        Collection<QueryFilter> filters;
        RangeKeyCondition rangeKeyCond;
        String tableName = this.getTable().getTableName();
        QueryRequest req = ((QueryRequest)spec.getRequest()).withTableName(tableName);
        KeyAttribute hashKey = spec.getHashKey();
        if (hashKey != null) {
            req.addKeyConditionsEntry(hashKey.getName(), new Condition().withComparisonOperator(ComparisonOperator.EQ).withAttributeValueList(InternalUtils.toAttributeValue(hashKey.getValue())));
        }
        if ((rangeKeyCond = spec.getRangeKeyCondition()) != null) {
            KeyConditions keyCond = rangeKeyCond.getKeyCondition();
            if (keyCond == null) {
                throw new IllegalArgumentException("key condition not specified in range key condition");
            }
            Object[] values = rangeKeyCond.getValues();
            if (values == null) {
                throw new IllegalArgumentException("key condition values not specified in range key condition");
            }
            req.addKeyConditionsEntry(rangeKeyCond.getAttrName(), new Condition().withComparisonOperator(keyCond.toComparisonOperator()).withAttributeValueList(InternalUtils.toAttributeValues(values)));
        }
        if ((filters = spec.getQueryFilters()) != null) {
            req.setQueryFilter(InternalUtils.toAttributeConditionMap(filters));
        }
        if ((startKey = spec.getExclusiveStartKey()) != null) {
            req.setExclusiveStartKey(InternalUtils.toAttributeValueMap(startKey));
        }
        Map<String, AttributeValue> attrValMap = InternalUtils.fromSimpleMap(spec.getValueMap());
        req.withExpressionAttributeNames(spec.getNameMap()).withExpressionAttributeValues(attrValMap);
        return new QueryCollection(this.getClient(), spec);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition) {
        return this.query(new KeyAttribute(hashKeyName, hashKeyValue), rangeKeyCondition);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.query(new KeyAttribute(hashKeyName, hashKeyValue), rangeKeyCondition, queryFilters);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.query(new KeyAttribute(hashKeyName, hashKeyValue), rangeKeyCondition, filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.query(new KeyAttribute(hashKeyName, hashKeyValue), rangeKeyCondition, filterExpression, projectionExpression, nameMap, valueMap);
    }
}

