/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.InventoryFilter;
import com.amazonaws.services.simplesystemsmanagement.model.ResultAttribute;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class GetInventoryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<InventoryFilter> filters;
    private SdkInternalList<ResultAttribute> resultAttributes;
    private String nextToken;
    private Integer maxResults;

    public List<InventoryFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<InventoryFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList<InventoryFilter>(filters);
    }

    public GetInventoryRequest withFilters(InventoryFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new SdkInternalList<InventoryFilter>(filters.length));
        }
        for (InventoryFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public GetInventoryRequest withFilters(Collection<InventoryFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<ResultAttribute> getResultAttributes() {
        if (this.resultAttributes == null) {
            this.resultAttributes = new SdkInternalList();
        }
        return this.resultAttributes;
    }

    public void setResultAttributes(Collection<ResultAttribute> resultAttributes) {
        if (resultAttributes == null) {
            this.resultAttributes = null;
            return;
        }
        this.resultAttributes = new SdkInternalList<ResultAttribute>(resultAttributes);
    }

    public GetInventoryRequest withResultAttributes(ResultAttribute ... resultAttributes) {
        if (this.resultAttributes == null) {
            this.setResultAttributes(new SdkInternalList<ResultAttribute>(resultAttributes.length));
        }
        for (ResultAttribute ele : resultAttributes) {
            this.resultAttributes.add(ele);
        }
        return this;
    }

    public GetInventoryRequest withResultAttributes(Collection<ResultAttribute> resultAttributes) {
        this.setResultAttributes(resultAttributes);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetInventoryRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetInventoryRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getResultAttributes() != null) {
            sb.append("ResultAttributes: ").append(this.getResultAttributes()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventoryRequest)) {
            return false;
        }
        GetInventoryRequest other = (GetInventoryRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getResultAttributes() == null ^ this.getResultAttributes() == null) {
            return false;
        }
        if (other.getResultAttributes() != null && !other.getResultAttributes().equals(this.getResultAttributes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getResultAttributes() == null ? 0 : this.getResultAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public GetInventoryRequest clone() {
        return (GetInventoryRequest)super.clone();
    }
}

