/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeRegionsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeRegionsRequestMarshaller
implements Marshaller<Request<DescribeRegionsRequest>, DescribeRegionsRequest> {
    @Override
    public Request<DescribeRegionsRequest> marshall(DescribeRegionsRequest describeRegionsRequest) {
        SdkInternalList describeRegionsRequestFiltersList;
        if (describeRegionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeRegionsRequest> request = new DefaultRequest<DescribeRegionsRequest>(describeRegionsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeRegions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeRegionsRequestRegionNamesList = (SdkInternalList)describeRegionsRequest.getRegionNames();
        if (!describeRegionsRequestRegionNamesList.isEmpty() || !describeRegionsRequestRegionNamesList.isAutoConstruct()) {
            int regionNamesListIndex = 1;
            for (String describeRegionsRequestRegionNamesListValue : describeRegionsRequestRegionNamesList) {
                if (describeRegionsRequestRegionNamesListValue != null) {
                    request.addParameter("RegionName." + regionNamesListIndex, StringUtils.fromString(describeRegionsRequestRegionNamesListValue));
                }
                ++regionNamesListIndex;
            }
        }
        if (!(describeRegionsRequestFiltersList = (SdkInternalList)describeRegionsRequest.getFilters()).isEmpty() || !describeRegionsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeRegionsRequestFiltersListValue : describeRegionsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeRegionsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeRegionsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeRegionsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

