/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.model.GetChangeRequest;
import com.amazonaws.services.route53.model.GetChangeResult;
import com.amazonaws.services.route53.waiters.GetChangeFunction;
import com.amazonaws.services.route53.waiters.ResourceRecordSetsChanged;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonRoute53Waiters {
    private final AmazonRoute53 client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonRoute53Waiters(AmazonRoute53 client) {
        this.client = client;
    }

    public Waiter<GetChangeRequest> resourceRecordSetsChanged() {
        return new WaiterBuilder<GetChangeRequest, GetChangeResult>().withSdkFunction(new GetChangeFunction(this.client)).withAcceptors(new ResourceRecordSetsChanged.IsINSYNCMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

