/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ReportInstanceStatusRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReportInstanceStatusRequestMarshaller
implements Marshaller<Request<ReportInstanceStatusRequest>, ReportInstanceStatusRequest> {
    @Override
    public Request<ReportInstanceStatusRequest> marshall(ReportInstanceStatusRequest reportInstanceStatusRequest) {
        SdkInternalList reportInstanceStatusRequestReasonCodesList;
        if (reportInstanceStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReportInstanceStatusRequest> request = new DefaultRequest<ReportInstanceStatusRequest>(reportInstanceStatusRequest, "AmazonEC2");
        request.addParameter("Action", "ReportInstanceStatus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList reportInstanceStatusRequestInstancesList = (SdkInternalList)reportInstanceStatusRequest.getInstances();
        if (!reportInstanceStatusRequestInstancesList.isEmpty() || !reportInstanceStatusRequestInstancesList.isAutoConstruct()) {
            int instancesListIndex = 1;
            for (String reportInstanceStatusRequestInstancesListValue : reportInstanceStatusRequestInstancesList) {
                if (reportInstanceStatusRequestInstancesListValue != null) {
                    request.addParameter("InstanceId." + instancesListIndex, StringUtils.fromString(reportInstanceStatusRequestInstancesListValue));
                }
                ++instancesListIndex;
            }
        }
        if (reportInstanceStatusRequest.getStatus() != null) {
            request.addParameter("Status", StringUtils.fromString(reportInstanceStatusRequest.getStatus()));
        }
        if (reportInstanceStatusRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate(reportInstanceStatusRequest.getStartTime()));
        }
        if (reportInstanceStatusRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate(reportInstanceStatusRequest.getEndTime()));
        }
        if (!(reportInstanceStatusRequestReasonCodesList = (SdkInternalList)reportInstanceStatusRequest.getReasonCodes()).isEmpty() || !reportInstanceStatusRequestReasonCodesList.isAutoConstruct()) {
            int reasonCodesListIndex = 1;
            for (String reportInstanceStatusRequestReasonCodesListValue : reportInstanceStatusRequestReasonCodesList) {
                if (reportInstanceStatusRequestReasonCodesListValue != null) {
                    request.addParameter("ReasonCode." + reasonCodesListIndex, StringUtils.fromString(reportInstanceStatusRequestReasonCodesListValue));
                }
                ++reasonCodesListIndex;
            }
        }
        if (reportInstanceStatusRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(reportInstanceStatusRequest.getDescription()));
        }
        return request;
    }
}

