/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.codecommit.AWSCodeCommitAsync;
import com.amazonaws.services.codecommit.AWSCodeCommitAsyncClientBuilder;
import com.amazonaws.services.codecommit.AWSCodeCommitClient;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesRequest;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesResult;
import com.amazonaws.services.codecommit.model.CreateBranchRequest;
import com.amazonaws.services.codecommit.model.CreateBranchResult;
import com.amazonaws.services.codecommit.model.CreateRepositoryRequest;
import com.amazonaws.services.codecommit.model.CreateRepositoryResult;
import com.amazonaws.services.codecommit.model.DeleteRepositoryRequest;
import com.amazonaws.services.codecommit.model.DeleteRepositoryResult;
import com.amazonaws.services.codecommit.model.GetBlobRequest;
import com.amazonaws.services.codecommit.model.GetBlobResult;
import com.amazonaws.services.codecommit.model.GetBranchRequest;
import com.amazonaws.services.codecommit.model.GetBranchResult;
import com.amazonaws.services.codecommit.model.GetCommitRequest;
import com.amazonaws.services.codecommit.model.GetCommitResult;
import com.amazonaws.services.codecommit.model.GetDifferencesRequest;
import com.amazonaws.services.codecommit.model.GetDifferencesResult;
import com.amazonaws.services.codecommit.model.GetRepositoryRequest;
import com.amazonaws.services.codecommit.model.GetRepositoryResult;
import com.amazonaws.services.codecommit.model.GetRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.GetRepositoryTriggersResult;
import com.amazonaws.services.codecommit.model.ListBranchesRequest;
import com.amazonaws.services.codecommit.model.ListBranchesResult;
import com.amazonaws.services.codecommit.model.ListRepositoriesRequest;
import com.amazonaws.services.codecommit.model.ListRepositoriesResult;
import com.amazonaws.services.codecommit.model.PutRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.PutRepositoryTriggersResult;
import com.amazonaws.services.codecommit.model.TestRepositoryTriggersRequest;
import com.amazonaws.services.codecommit.model.TestRepositoryTriggersResult;
import com.amazonaws.services.codecommit.model.UpdateDefaultBranchRequest;
import com.amazonaws.services.codecommit.model.UpdateDefaultBranchResult;
import com.amazonaws.services.codecommit.model.UpdateRepositoryDescriptionRequest;
import com.amazonaws.services.codecommit.model.UpdateRepositoryDescriptionResult;
import com.amazonaws.services.codecommit.model.UpdateRepositoryNameRequest;
import com.amazonaws.services.codecommit.model.UpdateRepositoryNameResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCodeCommitAsyncClient
extends AWSCodeCommitClient
implements AWSCodeCommitAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSCodeCommitAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSCodeCommitAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSCodeCommitAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSCodeCommitAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSCodeCommitAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSCodeCommitAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSCodeCommitAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSCodeCommitAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSCodeCommitAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSCodeCommitAsyncClientBuilder asyncBuilder() {
        return AWSCodeCommitAsyncClientBuilder.standard();
    }

    AWSCodeCommitAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchGetRepositoriesResult> batchGetRepositoriesAsync(BatchGetRepositoriesRequest request) {
        return this.batchGetRepositoriesAsync(request, null);
    }

    @Override
    public Future<BatchGetRepositoriesResult> batchGetRepositoriesAsync(BatchGetRepositoriesRequest request, final AsyncHandler<BatchGetRepositoriesRequest, BatchGetRepositoriesResult> asyncHandler) {
        final BatchGetRepositoriesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<BatchGetRepositoriesResult>(){

            @Override
            public BatchGetRepositoriesResult call() throws Exception {
                BatchGetRepositoriesResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeBatchGetRepositories(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBranchResult> createBranchAsync(CreateBranchRequest request) {
        return this.createBranchAsync(request, null);
    }

    @Override
    public Future<CreateBranchResult> createBranchAsync(CreateBranchRequest request, final AsyncHandler<CreateBranchRequest, CreateBranchResult> asyncHandler) {
        final CreateBranchRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBranchResult>(){

            @Override
            public CreateBranchResult call() throws Exception {
                CreateBranchResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeCreateBranch(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRepositoryResult> createRepositoryAsync(CreateRepositoryRequest request) {
        return this.createRepositoryAsync(request, null);
    }

    @Override
    public Future<CreateRepositoryResult> createRepositoryAsync(CreateRepositoryRequest request, final AsyncHandler<CreateRepositoryRequest, CreateRepositoryResult> asyncHandler) {
        final CreateRepositoryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateRepositoryResult>(){

            @Override
            public CreateRepositoryResult call() throws Exception {
                CreateRepositoryResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeCreateRepository(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRepositoryResult> deleteRepositoryAsync(DeleteRepositoryRequest request) {
        return this.deleteRepositoryAsync(request, null);
    }

    @Override
    public Future<DeleteRepositoryResult> deleteRepositoryAsync(DeleteRepositoryRequest request, final AsyncHandler<DeleteRepositoryRequest, DeleteRepositoryResult> asyncHandler) {
        final DeleteRepositoryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteRepositoryResult>(){

            @Override
            public DeleteRepositoryResult call() throws Exception {
                DeleteRepositoryResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeDeleteRepository(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBlobResult> getBlobAsync(GetBlobRequest request) {
        return this.getBlobAsync(request, null);
    }

    @Override
    public Future<GetBlobResult> getBlobAsync(GetBlobRequest request, final AsyncHandler<GetBlobRequest, GetBlobResult> asyncHandler) {
        final GetBlobRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBlobResult>(){

            @Override
            public GetBlobResult call() throws Exception {
                GetBlobResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeGetBlob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetBranchResult> getBranchAsync(GetBranchRequest request) {
        return this.getBranchAsync(request, null);
    }

    @Override
    public Future<GetBranchResult> getBranchAsync(GetBranchRequest request, final AsyncHandler<GetBranchRequest, GetBranchResult> asyncHandler) {
        final GetBranchRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetBranchResult>(){

            @Override
            public GetBranchResult call() throws Exception {
                GetBranchResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeGetBranch(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCommitResult> getCommitAsync(GetCommitRequest request) {
        return this.getCommitAsync(request, null);
    }

    @Override
    public Future<GetCommitResult> getCommitAsync(GetCommitRequest request, final AsyncHandler<GetCommitRequest, GetCommitResult> asyncHandler) {
        final GetCommitRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCommitResult>(){

            @Override
            public GetCommitResult call() throws Exception {
                GetCommitResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeGetCommit(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDifferencesResult> getDifferencesAsync(GetDifferencesRequest request) {
        return this.getDifferencesAsync(request, null);
    }

    @Override
    public Future<GetDifferencesResult> getDifferencesAsync(GetDifferencesRequest request, final AsyncHandler<GetDifferencesRequest, GetDifferencesResult> asyncHandler) {
        final GetDifferencesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDifferencesResult>(){

            @Override
            public GetDifferencesResult call() throws Exception {
                GetDifferencesResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeGetDifferences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRepositoryResult> getRepositoryAsync(GetRepositoryRequest request) {
        return this.getRepositoryAsync(request, null);
    }

    @Override
    public Future<GetRepositoryResult> getRepositoryAsync(GetRepositoryRequest request, final AsyncHandler<GetRepositoryRequest, GetRepositoryResult> asyncHandler) {
        final GetRepositoryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRepositoryResult>(){

            @Override
            public GetRepositoryResult call() throws Exception {
                GetRepositoryResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeGetRepository(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRepositoryTriggersResult> getRepositoryTriggersAsync(GetRepositoryTriggersRequest request) {
        return this.getRepositoryTriggersAsync(request, null);
    }

    @Override
    public Future<GetRepositoryTriggersResult> getRepositoryTriggersAsync(GetRepositoryTriggersRequest request, final AsyncHandler<GetRepositoryTriggersRequest, GetRepositoryTriggersResult> asyncHandler) {
        final GetRepositoryTriggersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRepositoryTriggersResult>(){

            @Override
            public GetRepositoryTriggersResult call() throws Exception {
                GetRepositoryTriggersResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeGetRepositoryTriggers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListBranchesResult> listBranchesAsync(ListBranchesRequest request) {
        return this.listBranchesAsync(request, null);
    }

    @Override
    public Future<ListBranchesResult> listBranchesAsync(ListBranchesRequest request, final AsyncHandler<ListBranchesRequest, ListBranchesResult> asyncHandler) {
        final ListBranchesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListBranchesResult>(){

            @Override
            public ListBranchesResult call() throws Exception {
                ListBranchesResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeListBranches(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRepositoriesResult> listRepositoriesAsync(ListRepositoriesRequest request) {
        return this.listRepositoriesAsync(request, null);
    }

    @Override
    public Future<ListRepositoriesResult> listRepositoriesAsync(ListRepositoriesRequest request, final AsyncHandler<ListRepositoriesRequest, ListRepositoriesResult> asyncHandler) {
        final ListRepositoriesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRepositoriesResult>(){

            @Override
            public ListRepositoriesResult call() throws Exception {
                ListRepositoriesResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeListRepositories(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutRepositoryTriggersResult> putRepositoryTriggersAsync(PutRepositoryTriggersRequest request) {
        return this.putRepositoryTriggersAsync(request, null);
    }

    @Override
    public Future<PutRepositoryTriggersResult> putRepositoryTriggersAsync(PutRepositoryTriggersRequest request, final AsyncHandler<PutRepositoryTriggersRequest, PutRepositoryTriggersResult> asyncHandler) {
        final PutRepositoryTriggersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutRepositoryTriggersResult>(){

            @Override
            public PutRepositoryTriggersResult call() throws Exception {
                PutRepositoryTriggersResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executePutRepositoryTriggers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TestRepositoryTriggersResult> testRepositoryTriggersAsync(TestRepositoryTriggersRequest request) {
        return this.testRepositoryTriggersAsync(request, null);
    }

    @Override
    public Future<TestRepositoryTriggersResult> testRepositoryTriggersAsync(TestRepositoryTriggersRequest request, final AsyncHandler<TestRepositoryTriggersRequest, TestRepositoryTriggersResult> asyncHandler) {
        final TestRepositoryTriggersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TestRepositoryTriggersResult>(){

            @Override
            public TestRepositoryTriggersResult call() throws Exception {
                TestRepositoryTriggersResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeTestRepositoryTriggers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateDefaultBranchResult> updateDefaultBranchAsync(UpdateDefaultBranchRequest request) {
        return this.updateDefaultBranchAsync(request, null);
    }

    @Override
    public Future<UpdateDefaultBranchResult> updateDefaultBranchAsync(UpdateDefaultBranchRequest request, final AsyncHandler<UpdateDefaultBranchRequest, UpdateDefaultBranchResult> asyncHandler) {
        final UpdateDefaultBranchRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateDefaultBranchResult>(){

            @Override
            public UpdateDefaultBranchResult call() throws Exception {
                UpdateDefaultBranchResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeUpdateDefaultBranch(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRepositoryDescriptionResult> updateRepositoryDescriptionAsync(UpdateRepositoryDescriptionRequest request) {
        return this.updateRepositoryDescriptionAsync(request, null);
    }

    @Override
    public Future<UpdateRepositoryDescriptionResult> updateRepositoryDescriptionAsync(UpdateRepositoryDescriptionRequest request, final AsyncHandler<UpdateRepositoryDescriptionRequest, UpdateRepositoryDescriptionResult> asyncHandler) {
        final UpdateRepositoryDescriptionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRepositoryDescriptionResult>(){

            @Override
            public UpdateRepositoryDescriptionResult call() throws Exception {
                UpdateRepositoryDescriptionResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeUpdateRepositoryDescription(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRepositoryNameResult> updateRepositoryNameAsync(UpdateRepositoryNameRequest request) {
        return this.updateRepositoryNameAsync(request, null);
    }

    @Override
    public Future<UpdateRepositoryNameResult> updateRepositoryNameAsync(UpdateRepositoryNameRequest request, final AsyncHandler<UpdateRepositoryNameRequest, UpdateRepositoryNameResult> asyncHandler) {
        final UpdateRepositoryNameRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRepositoryNameResult>(){

            @Override
            public UpdateRepositoryNameResult call() throws Exception {
                UpdateRepositoryNameResult result = null;
                try {
                    result = AWSCodeCommitAsyncClient.this.executeUpdateRepositoryName(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

