/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lexruntime.model.ContentType;
import com.amazonaws.services.lexruntime.model.GenericAttachment;
import com.amazonaws.services.lexruntime.model.transform.ResponseCardMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResponseCard
implements Serializable,
Cloneable,
StructuredPojo {
    private String version;
    private String contentType;
    private List<GenericAttachment> genericAttachments;

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public ResponseCard withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ResponseCard withContentType(String contentType) {
        this.setContentType(contentType);
        return this;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType.toString();
    }

    public ResponseCard withContentType(ContentType contentType) {
        this.setContentType(contentType);
        return this;
    }

    public List<GenericAttachment> getGenericAttachments() {
        return this.genericAttachments;
    }

    public void setGenericAttachments(Collection<GenericAttachment> genericAttachments) {
        if (genericAttachments == null) {
            this.genericAttachments = null;
            return;
        }
        this.genericAttachments = new ArrayList<GenericAttachment>(genericAttachments);
    }

    public ResponseCard withGenericAttachments(GenericAttachment ... genericAttachments) {
        if (this.genericAttachments == null) {
            this.setGenericAttachments(new ArrayList<GenericAttachment>(genericAttachments.length));
        }
        for (GenericAttachment ele : genericAttachments) {
            this.genericAttachments.add(ele);
        }
        return this;
    }

    public ResponseCard withGenericAttachments(Collection<GenericAttachment> genericAttachments) {
        this.setGenericAttachments(genericAttachments);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getContentType() != null) {
            sb.append("ContentType: ").append(this.getContentType()).append(",");
        }
        if (this.getGenericAttachments() != null) {
            sb.append("GenericAttachments: ").append(this.getGenericAttachments());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseCard)) {
            return false;
        }
        ResponseCard other = (ResponseCard)obj;
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getContentType() == null ^ this.getContentType() == null) {
            return false;
        }
        if (other.getContentType() != null && !other.getContentType().equals(this.getContentType())) {
            return false;
        }
        if (other.getGenericAttachments() == null ^ this.getGenericAttachments() == null) {
            return false;
        }
        return other.getGenericAttachments() == null || other.getGenericAttachments().equals(this.getGenericAttachments());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getContentType() == null ? 0 : this.getContentType().hashCode());
        hashCode = 31 * hashCode + (this.getGenericAttachments() == null ? 0 : this.getGenericAttachments().hashCode());
        return hashCode;
    }

    public ResponseCard clone() {
        try {
            return (ResponseCard)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResponseCardMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

