/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opsworks.model.CloudWatchLogsLogStream;
import com.amazonaws.services.opsworks.model.transform.CloudWatchLogsConfigurationMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CloudWatchLogsConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean enabled;
    private SdkInternalList<CloudWatchLogsLogStream> logStreams;

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public CloudWatchLogsConfiguration withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public List<CloudWatchLogsLogStream> getLogStreams() {
        if (this.logStreams == null) {
            this.logStreams = new SdkInternalList();
        }
        return this.logStreams;
    }

    public void setLogStreams(Collection<CloudWatchLogsLogStream> logStreams) {
        if (logStreams == null) {
            this.logStreams = null;
            return;
        }
        this.logStreams = new SdkInternalList<CloudWatchLogsLogStream>(logStreams);
    }

    public CloudWatchLogsConfiguration withLogStreams(CloudWatchLogsLogStream ... logStreams) {
        if (this.logStreams == null) {
            this.setLogStreams(new SdkInternalList<CloudWatchLogsLogStream>(logStreams.length));
        }
        for (CloudWatchLogsLogStream ele : logStreams) {
            this.logStreams.add(ele);
        }
        return this;
    }

    public CloudWatchLogsConfiguration withLogStreams(Collection<CloudWatchLogsLogStream> logStreams) {
        this.setLogStreams(logStreams);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getLogStreams() != null) {
            sb.append("LogStreams: ").append(this.getLogStreams());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsConfiguration)) {
            return false;
        }
        CloudWatchLogsConfiguration other = (CloudWatchLogsConfiguration)obj;
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getLogStreams() == null ^ this.getLogStreams() == null) {
            return false;
        }
        return other.getLogStreams() == null || other.getLogStreams().equals(this.getLogStreams());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getLogStreams() == null ? 0 : this.getLogStreams().hashCode());
        return hashCode;
    }

    public CloudWatchLogsConfiguration clone() {
        try {
            return (CloudWatchLogsConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLogsConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

