/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroupstaggingapi.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.resourcegroupstaggingapi.model.TagFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String paginationToken;
    private List<TagFilter> tagFilters;
    private Integer tagsPerPage;
    private List<String> resourceTypeFilters;

    public void setPaginationToken(String paginationToken) {
        this.paginationToken = paginationToken;
    }

    public String getPaginationToken() {
        return this.paginationToken;
    }

    public GetResourcesRequest withPaginationToken(String paginationToken) {
        this.setPaginationToken(paginationToken);
        return this;
    }

    public List<TagFilter> getTagFilters() {
        return this.tagFilters;
    }

    public void setTagFilters(Collection<TagFilter> tagFilters) {
        if (tagFilters == null) {
            this.tagFilters = null;
            return;
        }
        this.tagFilters = new ArrayList<TagFilter>(tagFilters);
    }

    public GetResourcesRequest withTagFilters(TagFilter ... tagFilters) {
        if (this.tagFilters == null) {
            this.setTagFilters(new ArrayList<TagFilter>(tagFilters.length));
        }
        for (TagFilter ele : tagFilters) {
            this.tagFilters.add(ele);
        }
        return this;
    }

    public GetResourcesRequest withTagFilters(Collection<TagFilter> tagFilters) {
        this.setTagFilters(tagFilters);
        return this;
    }

    public void setTagsPerPage(Integer tagsPerPage) {
        this.tagsPerPage = tagsPerPage;
    }

    public Integer getTagsPerPage() {
        return this.tagsPerPage;
    }

    public GetResourcesRequest withTagsPerPage(Integer tagsPerPage) {
        this.setTagsPerPage(tagsPerPage);
        return this;
    }

    public List<String> getResourceTypeFilters() {
        return this.resourceTypeFilters;
    }

    public void setResourceTypeFilters(Collection<String> resourceTypeFilters) {
        if (resourceTypeFilters == null) {
            this.resourceTypeFilters = null;
            return;
        }
        this.resourceTypeFilters = new ArrayList<String>(resourceTypeFilters);
    }

    public GetResourcesRequest withResourceTypeFilters(String ... resourceTypeFilters) {
        if (this.resourceTypeFilters == null) {
            this.setResourceTypeFilters(new ArrayList<String>(resourceTypeFilters.length));
        }
        for (String ele : resourceTypeFilters) {
            this.resourceTypeFilters.add(ele);
        }
        return this;
    }

    public GetResourcesRequest withResourceTypeFilters(Collection<String> resourceTypeFilters) {
        this.setResourceTypeFilters(resourceTypeFilters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPaginationToken() != null) {
            sb.append("PaginationToken: ").append(this.getPaginationToken()).append(",");
        }
        if (this.getTagFilters() != null) {
            sb.append("TagFilters: ").append(this.getTagFilters()).append(",");
        }
        if (this.getTagsPerPage() != null) {
            sb.append("TagsPerPage: ").append(this.getTagsPerPage()).append(",");
        }
        if (this.getResourceTypeFilters() != null) {
            sb.append("ResourceTypeFilters: ").append(this.getResourceTypeFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesRequest)) {
            return false;
        }
        GetResourcesRequest other = (GetResourcesRequest)obj;
        if (other.getPaginationToken() == null ^ this.getPaginationToken() == null) {
            return false;
        }
        if (other.getPaginationToken() != null && !other.getPaginationToken().equals(this.getPaginationToken())) {
            return false;
        }
        if (other.getTagFilters() == null ^ this.getTagFilters() == null) {
            return false;
        }
        if (other.getTagFilters() != null && !other.getTagFilters().equals(this.getTagFilters())) {
            return false;
        }
        if (other.getTagsPerPage() == null ^ this.getTagsPerPage() == null) {
            return false;
        }
        if (other.getTagsPerPage() != null && !other.getTagsPerPage().equals(this.getTagsPerPage())) {
            return false;
        }
        if (other.getResourceTypeFilters() == null ^ this.getResourceTypeFilters() == null) {
            return false;
        }
        return other.getResourceTypeFilters() == null || other.getResourceTypeFilters().equals(this.getResourceTypeFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPaginationToken() == null ? 0 : this.getPaginationToken().hashCode());
        hashCode = 31 * hashCode + (this.getTagFilters() == null ? 0 : this.getTagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getTagsPerPage() == null ? 0 : this.getTagsPerPage().hashCode());
        hashCode = 31 * hashCode + (this.getResourceTypeFilters() == null ? 0 : this.getResourceTypeFilters().hashCode());
        return hashCode;
    }

    @Override
    public GetResourcesRequest clone() {
        return (GetResourcesRequest)super.clone();
    }
}

