/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.machinelearning.model.transform.PredictionMarshaller;
import java.io.Serializable;
import java.util.Map;

public class Prediction
implements Serializable,
Cloneable,
StructuredPojo {
    private String predictedLabel;
    private Float predictedValue;
    private SdkInternalMap<String, Float> predictedScores;
    private SdkInternalMap<String, String> details;

    public void setPredictedLabel(String predictedLabel) {
        this.predictedLabel = predictedLabel;
    }

    public String getPredictedLabel() {
        return this.predictedLabel;
    }

    public Prediction withPredictedLabel(String predictedLabel) {
        this.setPredictedLabel(predictedLabel);
        return this;
    }

    public void setPredictedValue(Float predictedValue) {
        this.predictedValue = predictedValue;
    }

    public Float getPredictedValue() {
        return this.predictedValue;
    }

    public Prediction withPredictedValue(Float predictedValue) {
        this.setPredictedValue(predictedValue);
        return this;
    }

    public Map<String, Float> getPredictedScores() {
        if (this.predictedScores == null) {
            this.predictedScores = new SdkInternalMap();
        }
        return this.predictedScores;
    }

    public void setPredictedScores(Map<String, Float> predictedScores) {
        this.predictedScores = predictedScores == null ? null : new SdkInternalMap<String, Float>(predictedScores);
    }

    public Prediction withPredictedScores(Map<String, Float> predictedScores) {
        this.setPredictedScores(predictedScores);
        return this;
    }

    public Prediction addPredictedScoresEntry(String key, Float value) {
        if (null == this.predictedScores) {
            this.predictedScores = new SdkInternalMap();
        }
        if (this.predictedScores.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.predictedScores.put(key, value);
        return this;
    }

    public Prediction clearPredictedScoresEntries() {
        this.predictedScores = null;
        return this;
    }

    public Map<String, String> getDetails() {
        if (this.details == null) {
            this.details = new SdkInternalMap();
        }
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details == null ? null : new SdkInternalMap<String, String>(details);
    }

    public Prediction withDetails(Map<String, String> details) {
        this.setDetails(details);
        return this;
    }

    public Prediction addDetailsEntry(String key, String value) {
        if (null == this.details) {
            this.details = new SdkInternalMap();
        }
        if (this.details.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.details.put(key, value);
        return this;
    }

    public Prediction clearDetailsEntries() {
        this.details = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPredictedLabel() != null) {
            sb.append("PredictedLabel: ").append(this.getPredictedLabel()).append(",");
        }
        if (this.getPredictedValue() != null) {
            sb.append("PredictedValue: ").append(this.getPredictedValue()).append(",");
        }
        if (this.getPredictedScores() != null) {
            sb.append("PredictedScores: ").append(this.getPredictedScores()).append(",");
        }
        if (this.getDetails() != null) {
            sb.append("Details: ").append(this.getDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Prediction)) {
            return false;
        }
        Prediction other = (Prediction)obj;
        if (other.getPredictedLabel() == null ^ this.getPredictedLabel() == null) {
            return false;
        }
        if (other.getPredictedLabel() != null && !other.getPredictedLabel().equals(this.getPredictedLabel())) {
            return false;
        }
        if (other.getPredictedValue() == null ^ this.getPredictedValue() == null) {
            return false;
        }
        if (other.getPredictedValue() != null && !other.getPredictedValue().equals(this.getPredictedValue())) {
            return false;
        }
        if (other.getPredictedScores() == null ^ this.getPredictedScores() == null) {
            return false;
        }
        if (other.getPredictedScores() != null && !other.getPredictedScores().equals(this.getPredictedScores())) {
            return false;
        }
        if (other.getDetails() == null ^ this.getDetails() == null) {
            return false;
        }
        return other.getDetails() == null || other.getDetails().equals(this.getDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPredictedLabel() == null ? 0 : this.getPredictedLabel().hashCode());
        hashCode = 31 * hashCode + (this.getPredictedValue() == null ? 0 : this.getPredictedValue().hashCode());
        hashCode = 31 * hashCode + (this.getPredictedScores() == null ? 0 : this.getPredictedScores().hashCode());
        hashCode = 31 * hashCode + (this.getDetails() == null ? 0 : this.getDetails().hashCode());
        return hashCode;
    }

    public Prediction clone() {
        try {
            return (Prediction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PredictionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

